/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.manual.trace.SampledSlowTraceRecord;
import org.apache.skywalking.oap.server.core.analysis.manual.trace.SampledStatus4xxTraceRecord;
import org.apache.skywalking.oap.server.core.analysis.manual.trace.SampledStatus5xxTraceRecord;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.core.source.ISource;
import org.apache.skywalking.oap.server.core.source.ProcessRelation;

public class SampledTraceBuilder {
    private final NamingControl namingControl;
    private String traceId;
    private String uri;
    private long latency;
    private Reason reason;
    private String layer;
    private String serviceName;
    private String serviceInstanceName;
    private String processId;
    private String destProcessId;
    private int componentId;
    private DetectPoint detectPoint;
    private long timestamp;

    public void validate() {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.traceId) ? 1 : 0) != 0, (Object)"traceId can't be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.uri) ? 1 : 0) != 0, (Object)"uri can't be empty");
        Preconditions.checkArgument((this.latency >= 0L ? 1 : 0) != 0, (Object)"latency must bigger or equals zero");
        Preconditions.checkArgument((this.reason != null ? 1 : 0) != 0, (Object)"reason can't be empty");
        Preconditions.checkArgument((this.layer != null ? 1 : 0) != 0, (Object)"layer can't be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.serviceName) ? 1 : 0) != 0, (Object)"service name can't be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.serviceInstanceName) ? 1 : 0) != 0, (Object)"service instance name can't be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.processId) ? 1 : 0) != 0, (Object)"processId can't be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.destProcessId) ? 1 : 0) != 0, (Object)"destProcessId can't be empty");
        Preconditions.checkArgument((this.componentId > 0 ? 1 : 0) != 0, (Object)"componentId must bigger zero");
        Preconditions.checkArgument((this.detectPoint != null ? 1 : 0) != 0, (Object)"detestPoint can't be empty");
        Preconditions.checkArgument((this.timestamp > 0L ? 1 : 0) != 0, (Object)"timestamp must bigger zero");
    }

    public Record toRecord() {
        switch (this.reason) {
            case SLOW: {
                SampledSlowTraceRecord slowTraceRecord = new SampledSlowTraceRecord();
                slowTraceRecord.setScope(54);
                slowTraceRecord.setEntityId(IDManager.ProcessID.buildRelationId((IDManager.ProcessID.ProcessRelationDefine)new IDManager.ProcessID.ProcessRelationDefine(this.processId, this.destProcessId)));
                slowTraceRecord.setTraceId(this.traceId);
                slowTraceRecord.setUri(this.uri);
                slowTraceRecord.setLatency(this.latency);
                slowTraceRecord.setTimeBucket(TimeBucket.getTimeBucket((long)this.timestamp, (DownSampling)DownSampling.Second));
                slowTraceRecord.setTimestamp(this.timestamp);
                return slowTraceRecord;
            }
            case STATUS_4XX: {
                SampledStatus4xxTraceRecord status4xxTraceRecord = new SampledStatus4xxTraceRecord();
                status4xxTraceRecord.setScope(54);
                status4xxTraceRecord.setEntityId(IDManager.ProcessID.buildRelationId((IDManager.ProcessID.ProcessRelationDefine)new IDManager.ProcessID.ProcessRelationDefine(this.processId, this.destProcessId)));
                status4xxTraceRecord.setTraceId(this.traceId);
                status4xxTraceRecord.setUri(this.uri);
                status4xxTraceRecord.setLatency(this.latency);
                status4xxTraceRecord.setTimeBucket(TimeBucket.getTimeBucket((long)this.timestamp, (DownSampling)DownSampling.Second));
                status4xxTraceRecord.setTimestamp(this.timestamp);
                return status4xxTraceRecord;
            }
            case STATUS_5XX: {
                SampledStatus5xxTraceRecord status5xxTraceRecord = new SampledStatus5xxTraceRecord();
                status5xxTraceRecord.setScope(54);
                status5xxTraceRecord.setEntityId(IDManager.ProcessID.buildRelationId((IDManager.ProcessID.ProcessRelationDefine)new IDManager.ProcessID.ProcessRelationDefine(this.processId, this.destProcessId)));
                status5xxTraceRecord.setTraceId(this.traceId);
                status5xxTraceRecord.setUri(this.uri);
                status5xxTraceRecord.setLatency(this.latency);
                status5xxTraceRecord.setTimeBucket(TimeBucket.getTimeBucket((long)this.timestamp, (DownSampling)DownSampling.Second));
                status5xxTraceRecord.setTimestamp(this.timestamp);
                return status5xxTraceRecord;
            }
        }
        throw new IllegalArgumentException("unknown reason: " + this.reason);
    }

    public ISource toEntity() {
        ProcessRelation processRelation = new ProcessRelation();
        String serviceId = IDManager.ServiceID.buildId((String)this.namingControl.formatServiceName(this.serviceName), (boolean)Layer.nameOf((String)this.layer).isNormal());
        String instanceId = IDManager.ServiceInstanceID.buildId((String)serviceId, (String)this.namingControl.formatInstanceName(this.serviceInstanceName));
        processRelation.setInstanceId(instanceId);
        processRelation.setSourceProcessId(this.processId);
        processRelation.setDestProcessId(this.destProcessId);
        processRelation.setDetectPoint(this.detectPoint);
        processRelation.setComponentId(this.componentId);
        return processRelation;
    }

    @Generated
    public SampledTraceBuilder(NamingControl namingControl) {
        this.namingControl = namingControl;
    }

    @Generated
    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    @Generated
    public String getTraceId() {
        return this.traceId;
    }

    @Generated
    public void setUri(String uri) {
        this.uri = uri;
    }

    @Generated
    public String getUri() {
        return this.uri;
    }

    @Generated
    public void setLatency(long latency) {
        this.latency = latency;
    }

    @Generated
    public long getLatency() {
        return this.latency;
    }

    @Generated
    public void setReason(Reason reason) {
        this.reason = reason;
    }

    @Generated
    public Reason getReason() {
        return this.reason;
    }

    @Generated
    public void setLayer(String layer) {
        this.layer = layer;
    }

    @Generated
    public String getLayer() {
        return this.layer;
    }

    @Generated
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    @Generated
    public void setServiceInstanceName(String serviceInstanceName) {
        this.serviceInstanceName = serviceInstanceName;
    }

    @Generated
    public String getServiceInstanceName() {
        return this.serviceInstanceName;
    }

    @Generated
    public void setProcessId(String processId) {
        this.processId = processId;
    }

    @Generated
    public String getProcessId() {
        return this.processId;
    }

    @Generated
    public void setDestProcessId(String destProcessId) {
        this.destProcessId = destProcessId;
    }

    @Generated
    public String getDestProcessId() {
        return this.destProcessId;
    }

    @Generated
    public void setComponentId(int componentId) {
        this.componentId = componentId;
    }

    @Generated
    public int getComponentId() {
        return this.componentId;
    }

    @Generated
    public void setDetectPoint(DetectPoint detectPoint) {
        this.detectPoint = detectPoint;
    }

    @Generated
    public DetectPoint getDetectPoint() {
        return this.detectPoint;
    }

    @Generated
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    public static enum Reason {
        SLOW,
        STATUS_4XX,
        STATUS_5XX;

    }
}

