/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.analyzer.provider.trace;

import com.google.common.base.Splitter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.skywalking.oap.server.configuration.api.ConfigChangeWatcher;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;

public class CacheReadLatencyThresholdsAndWatcher
extends ConfigChangeWatcher {
    private AtomicReference<Map<String, Integer>> thresholds = new AtomicReference(new HashMap());
    private final String initialSettingsString;
    private volatile String dynamicSettingsString;

    public CacheReadLatencyThresholdsAndWatcher(String config, ModuleProvider provider) {
        super("agent-analyzer", provider, "slowCacheReadThreshold");
        this.initialSettingsString = config;
        this.activeSetting(config);
    }

    private void activeSetting(String config) {
        HashMap<String, Integer> newThresholds = new HashMap<String, Integer>();
        List settings = Splitter.on((char)',').splitToList((CharSequence)config);
        for (String setting : settings) {
            List typeValue = Splitter.on((String)":").splitToList((CharSequence)setting);
            if (typeValue.size() != 2) continue;
            newThresholds.put(((String)typeValue.get(0)).trim().toLowerCase(), Integer.parseInt(((String)typeValue.get(1)).trim()));
        }
        this.thresholds.set(newThresholds);
    }

    public int getThreshold(String type) {
        type = type.toLowerCase();
        if (this.thresholds.get().containsKey(type)) {
            return this.thresholds.get().get(type);
        }
        return Optional.ofNullable(this.thresholds.get().get("default")).orElse(Integer.MAX_VALUE);
    }

    public void notify(ConfigChangeWatcher.ConfigChangeEvent value) {
        if (ConfigChangeWatcher.EventType.DELETE.equals((Object)value.getEventType())) {
            this.dynamicSettingsString = null;
            this.activeSetting(this.initialSettingsString);
        } else {
            this.dynamicSettingsString = value.getNewValue();
            this.activeSetting(value.getNewValue());
        }
    }

    public String value() {
        return this.dynamicSettingsString;
    }
}

