/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.security.v1beta1;

import io.fabric8.istio.api.security.v1beta1.JWTHeader;
import io.fabric8.istio.api.security.v1beta1.JWTHeaderBuilder;
import io.fabric8.istio.api.security.v1beta1.JWTHeaderFluentImpl;
import io.fabric8.istio.api.security.v1beta1.JWTRule;
import io.fabric8.istio.api.security.v1beta1.JWTRuleFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class JWTRuleFluentImpl<A extends JWTRuleFluent<A>>
extends BaseFluent<A>
implements JWTRuleFluent<A> {
    private List<String> audiences = new ArrayList<String>();
    private Boolean forwardOriginalToken;
    private ArrayList<JWTHeaderBuilder> fromHeaders = new ArrayList();
    private List<String> fromParams = new ArrayList<String>();
    private String issuer;
    private String jwks;
    private String jwksUri;
    private String outputPayloadToHeader;

    public JWTRuleFluentImpl() {
    }

    public JWTRuleFluentImpl(JWTRule instance) {
        if (instance != null) {
            this.withAudiences(instance.getAudiences());
            this.withForwardOriginalToken(instance.getForwardOriginalToken());
            this.withFromHeaders(instance.getFromHeaders());
            this.withFromParams(instance.getFromParams());
            this.withIssuer(instance.getIssuer());
            this.withJwks(instance.getJwks());
            this.withJwksUri(instance.getJwksUri());
            this.withOutputPayloadToHeader(instance.getOutputPayloadToHeader());
        }
    }

    @Override
    public A addToAudiences(int index, String item) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAudiences(int index, String item) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAudiences(String ... items) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        for (String item : items) {
            this.audiences.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAudiences(Collection<String> items) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        for (String item : items) {
            this.audiences.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAudiences(String ... items) {
        for (String item : items) {
            if (this.audiences == null) continue;
            this.audiences.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAudiences(Collection<String> items) {
        for (String item : items) {
            if (this.audiences == null) continue;
            this.audiences.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAudiences() {
        return this.audiences;
    }

    @Override
    public String getAudience(int index) {
        return this.audiences.get(index);
    }

    @Override
    public String getFirstAudience() {
        return this.audiences.get(0);
    }

    @Override
    public String getLastAudience() {
        return this.audiences.get(this.audiences.size() - 1);
    }

    @Override
    public String getMatchingAudience(Predicate<String> predicate) {
        for (String item : this.audiences) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAudience(Predicate<String> predicate) {
        for (String item : this.audiences) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAudiences(List<String> audiences) {
        if (audiences != null) {
            this.audiences = new ArrayList<String>();
            for (String item : audiences) {
                this.addToAudiences(item);
            }
        } else {
            this.audiences = null;
        }
        return (A)this;
    }

    @Override
    public A withAudiences(String ... audiences) {
        if (this.audiences != null) {
            this.audiences.clear();
            this._visitables.remove((Object)"audiences");
        }
        if (audiences != null) {
            for (String item : audiences) {
                this.addToAudiences(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAudiences() {
        return this.audiences != null && !this.audiences.isEmpty();
    }

    @Override
    public Boolean getForwardOriginalToken() {
        return this.forwardOriginalToken;
    }

    @Override
    public A withForwardOriginalToken(Boolean forwardOriginalToken) {
        this.forwardOriginalToken = forwardOriginalToken;
        return (A)this;
    }

    @Override
    public Boolean hasForwardOriginalToken() {
        return this.forwardOriginalToken != null;
    }

    @Override
    public A addToFromHeaders(int index, JWTHeader item) {
        if (this.fromHeaders == null) {
            this.fromHeaders = new ArrayList();
        }
        JWTHeaderBuilder builder = new JWTHeaderBuilder(item);
        if (index < 0 || index >= this.fromHeaders.size()) {
            this._visitables.get((Object)"fromHeaders").add(builder);
            this.fromHeaders.add(builder);
        } else {
            this._visitables.get((Object)"fromHeaders").add(index, builder);
            this.fromHeaders.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToFromHeaders(int index, JWTHeader item) {
        if (this.fromHeaders == null) {
            this.fromHeaders = new ArrayList();
        }
        JWTHeaderBuilder builder = new JWTHeaderBuilder(item);
        if (index < 0 || index >= this.fromHeaders.size()) {
            this._visitables.get((Object)"fromHeaders").add(builder);
            this.fromHeaders.add(builder);
        } else {
            this._visitables.get((Object)"fromHeaders").set(index, builder);
            this.fromHeaders.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToFromHeaders(JWTHeader ... items) {
        if (this.fromHeaders == null) {
            this.fromHeaders = new ArrayList();
        }
        for (JWTHeader item : items) {
            JWTHeaderBuilder builder = new JWTHeaderBuilder(item);
            this._visitables.get((Object)"fromHeaders").add(builder);
            this.fromHeaders.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToFromHeaders(Collection<JWTHeader> items) {
        if (this.fromHeaders == null) {
            this.fromHeaders = new ArrayList();
        }
        for (JWTHeader item : items) {
            JWTHeaderBuilder builder = new JWTHeaderBuilder(item);
            this._visitables.get((Object)"fromHeaders").add(builder);
            this.fromHeaders.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromFromHeaders(JWTHeader ... items) {
        for (JWTHeader item : items) {
            JWTHeaderBuilder builder = new JWTHeaderBuilder(item);
            this._visitables.get((Object)"fromHeaders").remove(builder);
            if (this.fromHeaders == null) continue;
            this.fromHeaders.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromFromHeaders(Collection<JWTHeader> items) {
        for (JWTHeader item : items) {
            JWTHeaderBuilder builder = new JWTHeaderBuilder(item);
            this._visitables.get((Object)"fromHeaders").remove(builder);
            if (this.fromHeaders == null) continue;
            this.fromHeaders.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromFromHeaders(Predicate<JWTHeaderBuilder> predicate) {
        if (this.fromHeaders == null) {
            return (A)this;
        }
        Iterator<JWTHeaderBuilder> each = this.fromHeaders.iterator();
        List visitables = this._visitables.get((Object)"fromHeaders");
        while (each.hasNext()) {
            JWTHeaderBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<JWTHeader> getFromHeaders() {
        return this.fromHeaders != null ? JWTRuleFluentImpl.build(this.fromHeaders) : null;
    }

    @Override
    public List<JWTHeader> buildFromHeaders() {
        return this.fromHeaders != null ? JWTRuleFluentImpl.build(this.fromHeaders) : null;
    }

    @Override
    public JWTHeader buildFromHeader(int index) {
        return this.fromHeaders.get(index).build();
    }

    @Override
    public JWTHeader buildFirstFromHeader() {
        return this.fromHeaders.get(0).build();
    }

    @Override
    public JWTHeader buildLastFromHeader() {
        return this.fromHeaders.get(this.fromHeaders.size() - 1).build();
    }

    @Override
    public JWTHeader buildMatchingFromHeader(Predicate<JWTHeaderBuilder> predicate) {
        for (JWTHeaderBuilder item : this.fromHeaders) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingFromHeader(Predicate<JWTHeaderBuilder> predicate) {
        for (JWTHeaderBuilder item : this.fromHeaders) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withFromHeaders(List<JWTHeader> fromHeaders) {
        if (this.fromHeaders != null) {
            this._visitables.get((Object)"fromHeaders").clear();
        }
        if (fromHeaders != null) {
            this.fromHeaders = new ArrayList();
            for (JWTHeader item : fromHeaders) {
                this.addToFromHeaders(item);
            }
        } else {
            this.fromHeaders = null;
        }
        return (A)this;
    }

    @Override
    public A withFromHeaders(JWTHeader ... fromHeaders) {
        if (this.fromHeaders != null) {
            this.fromHeaders.clear();
            this._visitables.remove((Object)"fromHeaders");
        }
        if (fromHeaders != null) {
            for (JWTHeader item : fromHeaders) {
                this.addToFromHeaders(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasFromHeaders() {
        return this.fromHeaders != null && !this.fromHeaders.isEmpty();
    }

    @Override
    public A addNewFromHeader(String name, String prefix) {
        return this.addToFromHeaders(new JWTHeader(name, prefix));
    }

    @Override
    public JWTRuleFluent.FromHeadersNested<A> addNewFromHeader() {
        return new FromHeadersNestedImpl();
    }

    @Override
    public JWTRuleFluent.FromHeadersNested<A> addNewFromHeaderLike(JWTHeader item) {
        return new FromHeadersNestedImpl(-1, item);
    }

    @Override
    public JWTRuleFluent.FromHeadersNested<A> setNewFromHeaderLike(int index, JWTHeader item) {
        return new FromHeadersNestedImpl(index, item);
    }

    @Override
    public JWTRuleFluent.FromHeadersNested<A> editFromHeader(int index) {
        if (this.fromHeaders.size() <= index) {
            throw new RuntimeException("Can't edit fromHeaders. Index exceeds size.");
        }
        return this.setNewFromHeaderLike(index, this.buildFromHeader(index));
    }

    @Override
    public JWTRuleFluent.FromHeadersNested<A> editFirstFromHeader() {
        if (this.fromHeaders.size() == 0) {
            throw new RuntimeException("Can't edit first fromHeaders. The list is empty.");
        }
        return this.setNewFromHeaderLike(0, this.buildFromHeader(0));
    }

    @Override
    public JWTRuleFluent.FromHeadersNested<A> editLastFromHeader() {
        int index = this.fromHeaders.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last fromHeaders. The list is empty.");
        }
        return this.setNewFromHeaderLike(index, this.buildFromHeader(index));
    }

    @Override
    public JWTRuleFluent.FromHeadersNested<A> editMatchingFromHeader(Predicate<JWTHeaderBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.fromHeaders.size(); ++i) {
            if (!predicate.test(this.fromHeaders.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching fromHeaders. No match found.");
        }
        return this.setNewFromHeaderLike(index, this.buildFromHeader(index));
    }

    @Override
    public A addToFromParams(int index, String item) {
        if (this.fromParams == null) {
            this.fromParams = new ArrayList<String>();
        }
        this.fromParams.add(index, item);
        return (A)this;
    }

    @Override
    public A setToFromParams(int index, String item) {
        if (this.fromParams == null) {
            this.fromParams = new ArrayList<String>();
        }
        this.fromParams.set(index, item);
        return (A)this;
    }

    @Override
    public A addToFromParams(String ... items) {
        if (this.fromParams == null) {
            this.fromParams = new ArrayList<String>();
        }
        for (String item : items) {
            this.fromParams.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToFromParams(Collection<String> items) {
        if (this.fromParams == null) {
            this.fromParams = new ArrayList<String>();
        }
        for (String item : items) {
            this.fromParams.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromFromParams(String ... items) {
        for (String item : items) {
            if (this.fromParams == null) continue;
            this.fromParams.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromFromParams(Collection<String> items) {
        for (String item : items) {
            if (this.fromParams == null) continue;
            this.fromParams.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getFromParams() {
        return this.fromParams;
    }

    @Override
    public String getFromParam(int index) {
        return this.fromParams.get(index);
    }

    @Override
    public String getFirstFromParam() {
        return this.fromParams.get(0);
    }

    @Override
    public String getLastFromParam() {
        return this.fromParams.get(this.fromParams.size() - 1);
    }

    @Override
    public String getMatchingFromParam(Predicate<String> predicate) {
        for (String item : this.fromParams) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingFromParam(Predicate<String> predicate) {
        for (String item : this.fromParams) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withFromParams(List<String> fromParams) {
        if (fromParams != null) {
            this.fromParams = new ArrayList<String>();
            for (String item : fromParams) {
                this.addToFromParams(item);
            }
        } else {
            this.fromParams = null;
        }
        return (A)this;
    }

    @Override
    public A withFromParams(String ... fromParams) {
        if (this.fromParams != null) {
            this.fromParams.clear();
            this._visitables.remove((Object)"fromParams");
        }
        if (fromParams != null) {
            for (String item : fromParams) {
                this.addToFromParams(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasFromParams() {
        return this.fromParams != null && !this.fromParams.isEmpty();
    }

    @Override
    public String getIssuer() {
        return this.issuer;
    }

    @Override
    public A withIssuer(String issuer) {
        this.issuer = issuer;
        return (A)this;
    }

    @Override
    public Boolean hasIssuer() {
        return this.issuer != null;
    }

    @Override
    public String getJwks() {
        return this.jwks;
    }

    @Override
    public A withJwks(String jwks) {
        this.jwks = jwks;
        return (A)this;
    }

    @Override
    public Boolean hasJwks() {
        return this.jwks != null;
    }

    @Override
    public String getJwksUri() {
        return this.jwksUri;
    }

    @Override
    public A withJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
        return (A)this;
    }

    @Override
    public Boolean hasJwksUri() {
        return this.jwksUri != null;
    }

    @Override
    public String getOutputPayloadToHeader() {
        return this.outputPayloadToHeader;
    }

    @Override
    public A withOutputPayloadToHeader(String outputPayloadToHeader) {
        this.outputPayloadToHeader = outputPayloadToHeader;
        return (A)this;
    }

    @Override
    public Boolean hasOutputPayloadToHeader() {
        return this.outputPayloadToHeader != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JWTRuleFluentImpl that = (JWTRuleFluentImpl)o;
        if (!Objects.equals(this.audiences, that.audiences)) {
            return false;
        }
        if (!Objects.equals(this.forwardOriginalToken, that.forwardOriginalToken)) {
            return false;
        }
        if (!Objects.equals(this.fromHeaders, that.fromHeaders)) {
            return false;
        }
        if (!Objects.equals(this.fromParams, that.fromParams)) {
            return false;
        }
        if (!Objects.equals(this.issuer, that.issuer)) {
            return false;
        }
        if (!Objects.equals(this.jwks, that.jwks)) {
            return false;
        }
        if (!Objects.equals(this.jwksUri, that.jwksUri)) {
            return false;
        }
        return Objects.equals(this.outputPayloadToHeader, that.outputPayloadToHeader);
    }

    public int hashCode() {
        return Objects.hash(this.audiences, this.forwardOriginalToken, this.fromHeaders, this.fromParams, this.issuer, this.jwks, this.jwksUri, this.outputPayloadToHeader, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.audiences != null && !this.audiences.isEmpty()) {
            sb.append("audiences:");
            sb.append(this.audiences + ",");
        }
        if (this.forwardOriginalToken != null) {
            sb.append("forwardOriginalToken:");
            sb.append(this.forwardOriginalToken + ",");
        }
        if (this.fromHeaders != null) {
            sb.append("fromHeaders:");
            sb.append(this.fromHeaders + ",");
        }
        if (this.fromParams != null && !this.fromParams.isEmpty()) {
            sb.append("fromParams:");
            sb.append(this.fromParams + ",");
        }
        if (this.issuer != null) {
            sb.append("issuer:");
            sb.append(this.issuer + ",");
        }
        if (this.jwks != null) {
            sb.append("jwks:");
            sb.append(this.jwks + ",");
        }
        if (this.jwksUri != null) {
            sb.append("jwksUri:");
            sb.append(this.jwksUri + ",");
        }
        if (this.outputPayloadToHeader != null) {
            sb.append("outputPayloadToHeader:");
            sb.append(this.outputPayloadToHeader);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withForwardOriginalToken() {
        return this.withForwardOriginalToken(true);
    }

    class FromHeadersNestedImpl<N>
    extends JWTHeaderFluentImpl<JWTRuleFluent.FromHeadersNested<N>>
    implements JWTRuleFluent.FromHeadersNested<N>,
    Nested<N> {
        JWTHeaderBuilder builder;
        int index;

        FromHeadersNestedImpl(int index, JWTHeader item) {
            this.index = index;
            this.builder = new JWTHeaderBuilder(this, item);
        }

        FromHeadersNestedImpl() {
            this.index = -1;
            this.builder = new JWTHeaderBuilder(this);
        }

        @Override
        public N and() {
            return (N)JWTRuleFluentImpl.this.setToFromHeaders(this.index, this.builder.build());
        }

        @Override
        public N endFromHeader() {
            return this.and();
        }
    }
}

