/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider;

import java.io.FileNotFoundException;
import java.io.Reader;
import lombok.Generated;
import org.apache.skywalking.oap.server.configuration.api.ConfigChangeWatcher;
import org.apache.skywalking.oap.server.configuration.api.DynamicConfigurationService;
import org.apache.skywalking.oap.server.core.alarm.AlarmCallback;
import org.apache.skywalking.oap.server.core.alarm.AlarmModule;
import org.apache.skywalking.oap.server.core.alarm.AlarmStandardPersistence;
import org.apache.skywalking.oap.server.core.alarm.MetricsNotify;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmRulesWatcher;
import org.apache.skywalking.oap.server.core.alarm.provider.NotifyHandler;
import org.apache.skywalking.oap.server.core.alarm.provider.Rules;
import org.apache.skywalking.oap.server.core.alarm.provider.RulesReader;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.library.util.ResourceUtils;

public class AlarmModuleProvider
extends ModuleProvider {
    private NotifyHandler notifyHandler;
    private AlarmRulesWatcher alarmRulesWatcher;

    public String name() {
        return "default";
    }

    public Class<? extends ModuleDefine> module() {
        return AlarmModule.class;
    }

    public ModuleProvider.ConfigCreator newConfigCreator() {
        return null;
    }

    public void prepare() throws ServiceNotProvidedException, ModuleStartException {
        this.alarmRulesWatcher = new AlarmRulesWatcher(new Rules(), this, this.getManager());
        this.notifyHandler = new NotifyHandler(this.alarmRulesWatcher, this.getManager());
        this.registerServiceImplementation(MetricsNotify.class, (Service)this.notifyHandler);
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        DynamicConfigurationService dynamicConfigurationService = (DynamicConfigurationService)this.getManager().find("configuration").provider().getService(DynamicConfigurationService.class);
        dynamicConfigurationService.registerConfigChangeWatcher((ConfigChangeWatcher)this.alarmRulesWatcher);
    }

    public void notifyAfterCompleted() throws ServiceNotProvidedException, ModuleStartException {
        Reader applicationReader;
        try {
            applicationReader = ResourceUtils.read((String)"alarm-settings.yml");
        }
        catch (FileNotFoundException e) {
            throw new ModuleStartException("can't load alarm-settings.yml", (Throwable)e);
        }
        RulesReader reader = new RulesReader(applicationReader, this.getManager());
        Rules rules = reader.readRules();
        this.alarmRulesWatcher.initConfig(rules);
        this.notifyHandler.init(new AlarmCallback[]{new AlarmStandardPersistence(this.getManager())});
    }

    public String[] requiredModules() {
        return new String[]{"core", "configuration"};
    }

    @Generated
    public AlarmRulesWatcher getAlarmRulesWatcher() {
        return this.alarmRulesWatcher;
    }
}

