/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.datacarrier.buffer;

import org.apache.skywalking.oap.server.library.datacarrier.buffer.ArrayBlockingQueueBuffer;
import org.apache.skywalking.oap.server.library.datacarrier.buffer.BufferStrategy;
import org.apache.skywalking.oap.server.library.datacarrier.buffer.QueueBuffer;
import org.apache.skywalking.oap.server.library.datacarrier.partition.IDataPartitioner;

public class Channels<T> {
    private final QueueBuffer<T>[] bufferChannels;
    private IDataPartitioner<T> dataPartitioner;
    private final BufferStrategy strategy;
    private final long size;

    public Channels(int channelSize, int bufferSize, IDataPartitioner<T> partitioner, BufferStrategy strategy) {
        this.dataPartitioner = partitioner;
        this.strategy = strategy;
        this.bufferChannels = new QueueBuffer[channelSize];
        for (int i = 0; i < channelSize; ++i) {
            this.bufferChannels[i] = new ArrayBlockingQueueBuffer(bufferSize, strategy);
        }
        this.size = 1L * (long)channelSize * (long)bufferSize;
    }

    public boolean save(T data) {
        int maxRetryCount;
        int index = this.dataPartitioner.partition(this.bufferChannels.length, data);
        int retryCountDown = 1;
        if (BufferStrategy.IF_POSSIBLE.equals((Object)this.strategy) && (maxRetryCount = this.dataPartitioner.maxRetryCount()) > 1) {
            retryCountDown = maxRetryCount;
        }
        while (retryCountDown > 0) {
            if (this.bufferChannels[index].save(data)) {
                return true;
            }
            --retryCountDown;
        }
        return false;
    }

    public void setPartitioner(IDataPartitioner<T> dataPartitioner) {
        this.dataPartitioner = dataPartitioner;
    }

    public void setStrategy(BufferStrategy strategy) {
        for (QueueBuffer<T> buffer : this.bufferChannels) {
            buffer.setStrategy(strategy);
        }
    }

    public int getChannelSize() {
        return this.bufferChannels.length;
    }

    public long size() {
        return this.size;
    }

    public QueueBuffer<T> getBuffer(int index) {
        return this.bufferChannels[index];
    }
}

