/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntList;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.Call;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.core.storage.query.ITopologyQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;

public class JDBCTopologyQueryDAO
implements ITopologyQueryDAO {
    private final JDBCClient jdbcClient;
    private final TableHelper tableHelper;

    public List<Call.CallDetail> loadServiceRelationsDetectedAtServerSide(Duration duration, List<String> serviceIds) throws IOException {
        return this.loadServiceCalls("service_relation_server_side", duration, "source_service_id", "dest_service_id", serviceIds, DetectPoint.SERVER);
    }

    public List<Call.CallDetail> loadServiceRelationDetectedAtClientSide(Duration duration, List<String> serviceIds) throws IOException {
        return this.loadServiceCalls("service_relation_client_side", duration, "source_service_id", "dest_service_id", serviceIds, DetectPoint.CLIENT);
    }

    public List<Call.CallDetail> loadServiceRelationsDetectedAtServerSide(Duration duration) throws IOException {
        return this.loadServiceCalls("service_relation_server_side", duration, "source_service_id", "dest_service_id", new ArrayList<String>(0), DetectPoint.SERVER);
    }

    public List<Call.CallDetail> loadServiceRelationDetectedAtClientSide(Duration duration) throws IOException {
        return this.loadServiceCalls("service_relation_client_side", duration, "source_service_id", "dest_service_id", new ArrayList<String>(0), DetectPoint.CLIENT);
    }

    public List<Call.CallDetail> loadInstanceRelationDetectedAtServerSide(String clientServiceId, String serverServiceId, Duration duration) throws IOException {
        return this.loadServiceInstanceCalls("service_instance_relation_server_side", duration, "source_service_id", "dest_service_id", clientServiceId, serverServiceId, DetectPoint.SERVER);
    }

    public List<Call.CallDetail> loadInstanceRelationDetectedAtClientSide(String clientServiceId, String serverServiceId, Duration duration) throws IOException {
        return this.loadServiceInstanceCalls("service_instance_relation_client_side", duration, "source_service_id", "dest_service_id", clientServiceId, serverServiceId, DetectPoint.CLIENT);
    }

    public List<Call.CallDetail> loadEndpointRelation(Duration duration, String destEndpointId) throws IOException {
        List<Call.CallDetail> calls = this.loadEndpointFromSide("endpoint_relation_server_side", duration, "source_endpoint", "dest_endpoint", destEndpointId, false);
        calls.addAll(this.loadEndpointFromSide("endpoint_relation_server_side", duration, "source_endpoint", "dest_endpoint", destEndpointId, true));
        return calls;
    }

    public List<Call.CallDetail> loadProcessRelationDetectedAtClientSide(String serviceInstanceId, Duration duration) throws IOException {
        return this.loadProcessFromSide(duration, serviceInstanceId, DetectPoint.CLIENT);
    }

    public List<Call.CallDetail> loadProcessRelationDetectedAtServerSide(String serviceInstanceId, Duration duration) throws IOException {
        return this.loadProcessFromSide(duration, serviceInstanceId, DetectPoint.SERVER);
    }

    private List<Call.CallDetail> loadServiceCalls(String tableName, Duration duration, String sourceCName, String destCName, List<String> serviceIds, DetectPoint detectPoint) {
        List<String> tables = this.tableHelper.getTablesForRead(tableName, duration.getStartTimeBucket(), duration.getEndTimeBucket());
        ArrayList<Call.CallDetail> calls = new ArrayList<Call.CallDetail>();
        for (String table : tables) {
            Object[] conditions = new Object[serviceIds.size() * 2 + 3];
            conditions[0] = tableName;
            conditions[1] = duration.getStartTimeBucket();
            conditions[2] = duration.getEndTimeBucket();
            StringBuilder serviceIdMatchSql = new StringBuilder();
            if (serviceIds.size() > 0) {
                serviceIdMatchSql.append("and (");
                for (int i = 0; i < serviceIds.size(); ++i) {
                    serviceIdMatchSql.append(sourceCName + "=? or " + destCName + "=? ");
                    conditions[i * 2 + 3] = serviceIds.get(i);
                    conditions[i * 2 + 1 + 3] = serviceIds.get(i);
                    if (i == serviceIds.size() - 1) continue;
                    serviceIdMatchSql.append("or ");
                }
                serviceIdMatchSql.append(")");
            }
            this.jdbcClient.executeQuery("select entity_id, component_ids from " + table + " where table_name = ? and time_bucket>= ? and time_bucket<=? " + serviceIdMatchSql + " group by entity_id,component_ids", resultSet -> {
                this.buildServiceCalls(resultSet, calls, detectPoint);
                return null;
            }, conditions);
        }
        return calls;
    }

    private List<Call.CallDetail> loadServiceInstanceCalls(String tableName, Duration duration, String sourceCName, String descCName, String sourceServiceId, String destServiceId, DetectPoint detectPoint) throws IOException {
        List<String> tables = this.tableHelper.getTablesForRead(tableName, duration.getStartTimeBucket(), duration.getEndTimeBucket());
        ArrayList<Call.CallDetail> calls = new ArrayList<Call.CallDetail>();
        for (String table : tables) {
            Object[] conditions = new Object[]{tableName, duration.getStartTimeBucket(), duration.getEndTimeBucket(), sourceServiceId, destServiceId, destServiceId, sourceServiceId};
            StringBuilder serviceIdMatchSql = new StringBuilder("and ((").append(sourceCName).append("=? and ").append(descCName).append("=?").append(") or (").append(sourceCName).append("=? and ").append(descCName).append("=?").append("))");
            this.jdbcClient.executeQuery("select entity_id from " + table + " where table_name = ? and time_bucket>= ? and time_bucket<=? " + serviceIdMatchSql + " group by entity_id", resultSet -> {
                this.buildInstanceCalls(resultSet, calls, detectPoint);
                return null;
            }, conditions);
        }
        return calls;
    }

    private List<Call.CallDetail> loadEndpointFromSide(String tableName, Duration duration, String sourceCName, String destCName, String id, boolean isSourceId) throws IOException {
        ArrayList<Call.CallDetail> calls = new ArrayList<Call.CallDetail>();
        List<String> tables = this.tableHelper.getTablesForRead(tableName, duration.getStartTimeBucket(), duration.getEndTimeBucket());
        for (String table : tables) {
            Object[] conditions = new Object[]{tableName, duration.getStartTimeBucket(), duration.getEndTimeBucket(), id};
            this.jdbcClient.executeQuery("select entity_id from " + table + " where table_name = ? and time_bucket>= ? and time_bucket<=? and " + (isSourceId ? sourceCName : destCName) + "=? group by entity_id", resultSet -> {
                this.buildEndpointCalls(resultSet, calls, DetectPoint.SERVER);
                return null;
            }, conditions);
        }
        return calls;
    }

    private List<Call.CallDetail> loadProcessFromSide(Duration duration, String instanceId, DetectPoint detectPoint) throws IOException {
        String tableName = detectPoint == DetectPoint.SERVER ? "process_relation_server_side" : "process_relation_client_side";
        List<String> tables = this.tableHelper.getTablesForRead(tableName, duration.getStartTimeBucket(), duration.getEndTimeBucket());
        ArrayList<Call.CallDetail> calls = new ArrayList<Call.CallDetail>();
        for (String table : tables) {
            Object[] conditions = new Object[]{tableName, duration.getStartTimeBucket(), duration.getEndTimeBucket(), instanceId};
            this.jdbcClient.executeQuery("select entity_id, component_id from " + table + " where table_name = ? and time_bucket>= ? and time_bucket<=? and service_instance_id=? group by entity_id, component_id", resultSet -> {
                this.buildProcessCalls(resultSet, calls, detectPoint);
                return null;
            }, conditions);
        }
        return calls;
    }

    private void buildServiceCalls(ResultSet resultSet, List<Call.CallDetail> calls, DetectPoint detectPoint) throws SQLException {
        while (resultSet.next()) {
            String entityId = resultSet.getString("entity_id");
            IntList componentIds = new IntList(resultSet.getString("component_ids"));
            for (int i = 0; i < componentIds.size(); ++i) {
                Call.CallDetail call = new Call.CallDetail();
                call.buildFromServiceRelation(entityId, componentIds.get(i), detectPoint);
                calls.add(call);
            }
        }
    }

    private void buildInstanceCalls(ResultSet resultSet, List<Call.CallDetail> calls, DetectPoint detectPoint) throws SQLException {
        while (resultSet.next()) {
            Call.CallDetail call = new Call.CallDetail();
            String entityId = resultSet.getString("entity_id");
            call.buildFromInstanceRelation(entityId, detectPoint);
            calls.add(call);
        }
    }

    private void buildEndpointCalls(ResultSet resultSet, List<Call.CallDetail> calls, DetectPoint detectPoint) throws SQLException {
        while (resultSet.next()) {
            Call.CallDetail call = new Call.CallDetail();
            String entityId = resultSet.getString("entity_id");
            call.buildFromEndpointRelation(entityId, detectPoint);
            calls.add(call);
        }
    }

    private void buildProcessCalls(ResultSet resultSet, List<Call.CallDetail> calls, DetectPoint detectPoint) throws SQLException {
        while (resultSet.next()) {
            Call.CallDetail call = new Call.CallDetail();
            String entityId = resultSet.getString("entity_id");
            int componentId = resultSet.getInt("component_id");
            call.buildProcessRelation(entityId, componentId, detectPoint);
            calls.add(call);
        }
    }

    @Generated
    public JDBCTopologyQueryDAO(JDBCClient jdbcClient, TableHelper tableHelper) {
        this.jdbcClient = jdbcClient;
        this.tableHelper = tableHelper;
    }
}

