/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.xml.stream;

import jakarta.xml.bind.JAXBException;
import java.io.Closeable;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;
import org.apache.sis.storage.xml.stream.StaxDataStore;
import org.apache.sis.storage.xml.stream.StaxDataStoreProvider;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.MarshallerPool;

abstract class StaxStreamIO
implements AutoCloseable {
    protected final StaxDataStore owner;
    Closeable stream;
    private MarshallerPool jaxb;

    StaxStreamIO(StaxDataStore owner) {
        this.owner = Objects.requireNonNull(owner);
    }

    final MarshallerPool getMarshallerPool() throws JAXBException {
        if (this.jaxb == null) {
            StaxDataStoreProvider provider = this.owner.getProvider();
            if (provider != null) {
                this.jaxb = provider.getMarshallerPool();
            }
            if (this.jaxb == null) {
                throw new JAXBException(this.errors().getString((short)107));
            }
        }
        return this.jaxb;
    }

    @Override
    public void close() throws JAXBException, XMLStreamException, IOException {
        Closeable s = this.stream;
        this.stream = null;
        if (s != null && this.owner.canClose(s)) {
            s.close();
        }
    }

    protected final Errors errors() {
        return Errors.forLocale((Locale)this.owner.getLocale());
    }
}

