/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.image;

import java.awt.image.RenderedImage;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.apache.sis.io.stream.IOUtilities;
import org.apache.sis.io.stream.InternalOptionKey;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.image.DataStoreFilter;
import org.apache.sis.storage.image.FormatFilter;
import org.apache.sis.storage.image.WorldFileStoreProvider;

final class FormatFinder
implements AutoCloseable {
    final WorldFileStoreProvider provider;
    final StorageConnector connector;
    Object keepOpen;
    final Object storage;
    private ImageReader reader;
    private ImageWriter writer;
    private boolean readerLookupDone;
    private boolean writerLookupDone;
    final boolean isWritable;
    final boolean openAsWriter;
    final boolean fileIsEmpty;
    final String suffix;
    private final String preferredFormat;

    FormatFinder(WorldFileStoreProvider provider, StorageConnector connector) throws DataStoreException, IOException {
        this.provider = provider;
        this.connector = connector;
        Object storage = connector.getStorage();
        if (storage instanceof ImageReader) {
            this.reader = (ImageReader)storage;
            storage = this.reader.getInput();
            this.readerLookupDone = true;
        } else if (storage instanceof ImageWriter) {
            this.writer = (ImageWriter)storage;
            storage = this.writer.getOutput();
            this.writerLookupDone = true;
        }
        this.storage = storage;
        this.suffix = IOUtilities.extension(storage);
        Predicate<DataStoreProvider> filter = connector.getOption(InternalOptionKey.PREFERRED_PROVIDERS);
        String string = this.preferredFormat = filter instanceof DataStoreFilter ? ((DataStoreFilter)filter).preferred : null;
        if (this.writer != null) {
            this.isWritable = true;
            this.openAsWriter = true;
            this.fileIsEmpty = false;
        } else if (this.reader != null) {
            this.isWritable = this.reader.getInput() instanceof DataOutput;
            this.openAsWriter = false;
            this.fileIsEmpty = false;
        } else {
            Path path;
            this.isWritable = WorldFileStoreProvider.isWritable(connector, false);
            if (this.isWritable && (path = connector.getStorageAs(Path.class)) != null) {
                this.openAsWriter = this.fileIsEmpty = !Files.exists(path, new LinkOption[0]) || Files.size(path) == 0L;
                return;
            }
            this.fileIsEmpty = this.openAsWriter = IOUtilities.isWriteOnly(storage);
        }
    }

    final String[] getFormatName() throws DataStoreException, IOException {
        if (this.openAsWriter) {
            ImageWriterSpi spi;
            ImageWriter writer = this.getOrCreateWriter(null);
            if (writer != null && (spi = writer.getOriginatingProvider()) != null) {
                return spi.getFormatNames();
            }
        } else {
            ImageReaderSpi spi;
            ImageReader reader = this.getOrCreateReader();
            if (reader != null && (spi = reader.getOriginatingProvider()) != null) {
                return spi.getFormatNames();
            }
        }
        return null;
    }

    final ImageReader getOrCreateReader() throws DataStoreException, IOException {
        if (!this.readerLookupDone) {
            this.readerLookupDone = true;
            LinkedHashMap<ImageReaderSpi, Boolean> deferred = new LinkedHashMap<ImageReaderSpi, Boolean>();
            if (this.preferredFormat != null) {
                this.reader = FormatFilter.NAME.createReader(this.preferredFormat, this, deferred);
            }
            if (this.reader == null && this.suffix != null) {
                this.reader = FormatFilter.SUFFIX.createReader(this.suffix, this, deferred);
            }
            if (this.reader == null) {
                this.reader = FormatFilter.SUFFIX.createReader(null, this, deferred);
                if (this.reader == null) {
                    ImageInputStream stream = null;
                    for (Map.Entry<ImageReaderSpi, Boolean> entry : deferred.entrySet()) {
                        ImageReaderSpi p;
                        if (!entry.getValue().booleanValue()) continue;
                        if (stream == null) {
                            if (this.isWritable) {
                                stream = this.connector.getStorageAs(ImageOutputStream.class);
                            }
                            if (stream == null && (stream = this.connector.getStorageAs(ImageInputStream.class)) == null) break;
                        }
                        if (!(p = entry.getKey()).canDecodeInput(stream)) continue;
                        this.reader = p.createReaderInstance();
                        this.reader.setInput(stream);
                        this.keepOpen = stream;
                        break;
                    }
                }
            }
        }
        return this.reader;
    }

    final ImageWriter getOrCreateWriter(RenderedImage image) throws DataStoreException, IOException {
        if (!this.writerLookupDone) {
            this.writerLookupDone = true;
            LinkedHashMap<ImageWriterSpi, Boolean> deferred = new LinkedHashMap<ImageWriterSpi, Boolean>();
            if (this.preferredFormat != null) {
                this.writer = FormatFilter.NAME.createWriter(this.preferredFormat, this, image, deferred);
            }
            if (this.writer == null && this.suffix != null) {
                this.writer = FormatFilter.SUFFIX.createWriter(this.suffix, this, image, deferred);
            }
            if (this.writer == null) {
                this.writer = FormatFilter.SUFFIX.createWriter(null, this, image, deferred);
                if (this.writer == null) {
                    ImageOutputStream stream = null;
                    for (Map.Entry<ImageWriterSpi, Boolean> entry : deferred.entrySet()) {
                        if (!entry.getValue().booleanValue()) continue;
                        if (stream == null && (stream = this.connector.getStorageAs(ImageOutputStream.class)) == null) break;
                        ImageWriterSpi p = entry.getKey();
                        this.writer = p.createWriterInstance();
                        this.writer.setOutput(stream);
                        this.keepOpen = stream;
                        break;
                    }
                }
            }
        }
        return this.writer;
    }

    @Override
    public final void close() throws DataStoreException {
        this.connector.closeAllExcept(this.keepOpen);
    }
}

