/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.ExpressionClassBuilderInterface;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.compile.BaseJoinStrategy;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.shared.common.error.StandardException;

class NestedLoopJoinStrategy
extends BaseJoinStrategy {
    NestedLoopJoinStrategy() {
        int n = 3;
    }

    @Override
    public boolean feasible(Optimizable optimizable, OptimizablePredicateList optimizablePredicateList, Optimizer optimizer) throws StandardException {
        if (optimizable.isMaterializable()) {
            return true;
        }
        return optimizable.supportsMultipleInstantiations();
    }

    @Override
    public boolean multiplyBaseCostByOuterRows() {
        return true;
    }

    @Override
    public OptimizablePredicateList getBasePredicates(OptimizablePredicateList optimizablePredicateList, OptimizablePredicateList optimizablePredicateList2, Optimizable optimizable) throws StandardException {
        if (optimizablePredicateList != null) {
            optimizablePredicateList.transferAllPredicates(optimizablePredicateList2);
            optimizablePredicateList2.classify(optimizable, optimizable.getCurrentAccessPath().getConglomerateDescriptor());
        }
        return optimizablePredicateList2;
    }

    @Override
    public double nonBasePredicateSelectivity(Optimizable optimizable, OptimizablePredicateList optimizablePredicateList) {
        return 1.0;
    }

    @Override
    public void putBasePredicates(OptimizablePredicateList optimizablePredicateList, OptimizablePredicateList optimizablePredicateList2) throws StandardException {
        for (int i = optimizablePredicateList2.size() - 1; i >= 0; --i) {
            OptimizablePredicate optimizablePredicate = optimizablePredicateList2.getOptPredicate(i);
            optimizablePredicateList.addOptPredicate(optimizablePredicate);
            optimizablePredicateList2.removeOptPredicate(i);
        }
    }

    @Override
    public void estimateCost(Optimizable optimizable, OptimizablePredicateList optimizablePredicateList, ConglomerateDescriptor conglomerateDescriptor, CostEstimate costEstimate, Optimizer optimizer, CostEstimate costEstimate2) {
        costEstimate2.multiply(costEstimate.rowCount(), costEstimate2);
        if (optimizable.optimizerTracingIsOn()) {
            optimizable.getOptimizerTracer().traceCostOfNScans(optimizable.getTableNumber(), costEstimate.rowCount(), costEstimate2);
        }
    }

    @Override
    public int maxCapacity(int n, int n2, double d) {
        return Integer.MAX_VALUE;
    }

    @Override
    public String getName() {
        return "NESTEDLOOP";
    }

    @Override
    public int scanCostType() {
        return 2;
    }

    @Override
    public String getOperatorSymbol() {
        return "*";
    }

    @Override
    public String resultSetMethodName(boolean bl, boolean bl2, boolean bl3) {
        if (bl3) {
            return "getValidateCheckConstraintResultSet";
        }
        if (bl) {
            return "getBulkTableScanResultSet";
        }
        if (bl2) {
            return "getMultiProbeTableScanResultSet";
        }
        return "getTableScanResultSet";
    }

    @Override
    public String joinResultSetMethodName() {
        return "getNestedLoopJoinResultSet";
    }

    @Override
    public String halfOuterJoinResultSetMethodName() {
        return "getNestedLoopLeftOuterJoinResultSet";
    }

    @Override
    public int getScanArgs(TransactionController transactionController, MethodBuilder methodBuilder, Optimizable optimizable, OptimizablePredicateList optimizablePredicateList, OptimizablePredicateList optimizablePredicateList2, ExpressionClassBuilderInterface expressionClassBuilderInterface, int n, int n2, int n3, int n4, int n5, boolean bl, int n6, int n7, boolean bl2) throws StandardException {
        ExpressionClassBuilder expressionClassBuilder = (ExpressionClassBuilder)expressionClassBuilderInterface;
        int n8 = bl2 ? 26 : (n > 1 ? 26 : 24);
        this.fillInScanArgs1(transactionController, methodBuilder, optimizable, optimizablePredicateList, expressionClassBuilder, n2);
        if (bl2) {
            ((PredicateList)optimizablePredicateList).generateInListValues(expressionClassBuilder, methodBuilder);
        }
        this.fillInScanArgs2(methodBuilder, optimizable, n, n3, n4, n5, bl, n6);
        return n8;
    }

    @Override
    public void divideUpPredicateLists(Optimizable optimizable, OptimizablePredicateList optimizablePredicateList, OptimizablePredicateList optimizablePredicateList2, OptimizablePredicateList optimizablePredicateList3, OptimizablePredicateList optimizablePredicateList4, DataDictionary dataDictionary) throws StandardException {
        optimizablePredicateList.setPredicatesAndProperties(optimizablePredicateList2);
    }

    @Override
    public boolean doesMaterialization() {
        return false;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    protected boolean validForOutermostTable() {
        return true;
    }
}

