/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import org.apache.sis.metadata.internal.shared.AxisNames;
import org.apache.sis.referencing.internal.shared.AxisDirections;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;

public abstract class Transliterator
implements Serializable {
    private static final long serialVersionUID = 7115456393795045932L;
    static final int SPACES = -268419584;
    private static final Map<AxisDirection, String> CARTESIAN = Map.of(AxisDirection.EAST, "Easting", AxisDirection.WEST, "Westing", AxisDirection.NORTH, "Northing", AxisDirection.SOUTH, "Southing", AxisDirection.GEOCENTRIC_X, "Geocentric X", AxisDirection.GEOCENTRIC_Y, "Geocentric Y", AxisDirection.GEOCENTRIC_Z, "Geocentric Z");
    public static final Transliterator DEFAULT = new Default();
    public static final Transliterator IDENTITY = new Unicode();

    protected Transliterator() {
    }

    public String filter(String text) {
        CharSequence s = CharSequences.toASCII((CharSequence)text);
        StringBuilder buffer = null;
        int i = s.length();
        while (--i >= 0) {
            char c = s.charAt(i);
            if (c >= ' ') continue;
            if (buffer == null) {
                if (s == text) {
                    buffer = new StringBuilder(text);
                    s = buffer;
                } else {
                    buffer = (StringBuilder)s;
                }
            }
            if ((0xF0003E00 & '\u0001' << c) != 0) {
                buffer.setCharAt(i, ' ');
                if (i == 0 || c != '\n' || s.charAt(i - 1) != '\r') continue;
                buffer.deleteCharAt(--i);
                continue;
            }
            buffer.deleteCharAt(i);
        }
        return s.toString();
    }

    public String toShortAxisName(CoordinateSystem cs, AxisDirection direction, String name) {
        if (name.equalsIgnoreCase("Geodetic latitude") || name.equalsIgnoreCase("Planetodetic latitude")) {
            return "Latitude";
        }
        if (name.equalsIgnoreCase("Geodetic longitude") || name.equalsIgnoreCase("Planetodetic longitude")) {
            return "Longitude";
        }
        if (AxisDirections.isGeocentric(direction) && CharSequences.equalsFiltered((CharSequence)name, (CharSequence)direction.name(), (Characters.Filter)Characters.Filter.LETTERS_AND_DIGITS, (boolean)true)) {
            return null;
        }
        return name;
    }

    public String toLongAxisName(String csType, AxisDirection direction, String name) {
        if (csType != null) {
            switch (csType) {
                case "ellipsoidal": {
                    if (Transliterator.isLatLong("Latitude", name)) {
                        return "Geodetic latitude";
                    }
                    if (!Transliterator.isLatLong("Longitude", name)) break;
                    return "Geodetic longitude";
                }
                case "spherical": {
                    if (Transliterator.isLatLong("Latitude", name)) {
                        return "Spherical latitude";
                    }
                    if (!Transliterator.isLatLong("Longitude", name)) break;
                    return "Spherical longitude";
                }
                case "Cartesian": {
                    String c;
                    if (name.length() > 1 || (c = CARTESIAN.get(direction)) == null) break;
                    return c;
                }
            }
        }
        return AxisNames.toCamelCase((String)name);
    }

    private static boolean isLatLong(String expected, String name) {
        int length = name.length();
        return length >= 3 && length <= name.length() && CharSequences.startsWith((CharSequence)expected, (CharSequence)name, (boolean)true);
    }

    public String toLatinAbbreviation(CoordinateSystem cs, AxisDirection direction, String abbreviation) {
        if (abbreviation != null && !abbreviation.isEmpty()) {
            if (abbreviation.length() <= 2) {
                switch (abbreviation.charAt(0)) {
                    case '\u03b8': {
                        if (cs instanceof SphericalCS) {
                            abbreviation = "V";
                            break;
                        }
                        if (!(cs instanceof PolarCS)) break;
                        abbreviation = "U";
                        break;
                    }
                    case '\u03c6': {
                        if (cs instanceof SphericalCS) {
                            abbreviation = "U";
                            break;
                        }
                        if (!(cs instanceof EllipsoidalCS)) break;
                        abbreviation = "B";
                        break;
                    }
                    case '\u03a9': {
                        if (!(cs instanceof SphericalCS)) break;
                        abbreviation = "U";
                        break;
                    }
                    case '\u03bb': {
                        if (!(cs instanceof EllipsoidalCS)) break;
                        abbreviation = "L";
                    }
                }
            } else if (abbreviation.equalsIgnoreCase("Lat")) {
                abbreviation = "B";
            } else if (abbreviation.regionMatches(true, 0, "Long", 0, Math.min(3, Math.max(4, abbreviation.length())))) {
                abbreviation = "L";
            }
        }
        return abbreviation;
    }

    public String toUnicodeAbbreviation(String csType, AxisDirection direction, String abbreviation) {
        if (abbreviation.length() == 1) {
            String condition;
            String replacement;
            switch (abbreviation.charAt(0)) {
                case 'U': {
                    if ("polar".equals(csType)) {
                        return "\u03b8";
                    }
                    replacement = "\u03a9";
                    condition = "spherical";
                    break;
                }
                case 'V': {
                    replacement = "\u03b8";
                    condition = "spherical";
                    break;
                }
                case 'L': {
                    replacement = "\u03bb";
                    condition = "ellipsoidal";
                    break;
                }
                case 'B': 
                case 'P': {
                    replacement = "\u03c6";
                    condition = "ellipsoidal";
                    break;
                }
                default: {
                    return abbreviation;
                }
            }
            if (condition.equals(csType)) {
                return replacement;
            }
        } else {
            if (Transliterator.isLatLong("Latitude", abbreviation)) {
                return "\u03c6";
            }
            if (Transliterator.isLatLong("Longitude", abbreviation)) {
                return "\u03bb";
            }
        }
        return abbreviation;
    }

    private static final class Default
    extends Transliterator {
        private static final long serialVersionUID = 4869597020294928525L;

        private Default() {
        }

        public String toString() {
            return "DEFAULT";
        }

        Object readResolve() throws ObjectStreamException {
            return DEFAULT;
        }
    }

    private static final class Unicode
    extends Transliterator {
        private static final long serialVersionUID = 7392131912748253956L;

        private Unicode() {
        }

        @Override
        public String filter(String text) {
            return text;
        }

        @Override
        public String toShortAxisName(CoordinateSystem cs, AxisDirection direction, String name) {
            return name;
        }

        @Override
        public String toLongAxisName(String csType, AxisDirection direction, String name) {
            return name;
        }

        @Override
        public String toLatinAbbreviation(CoordinateSystem cs, AxisDirection direction, String abbreviation) {
            return abbreviation;
        }

        @Override
        public String toUnicodeAbbreviation(String csType, AxisDirection direction, String abbreviation) {
            return abbreviation;
        }

        public String toString() {
            return "IDENTITY";
        }

        Object readResolve() throws ObjectStreamException {
            return IDENTITY;
        }
    }
}

