/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.config;

import org.apache.shenyu.admin.config.properties.ClusterProperties;
import org.apache.shenyu.admin.config.properties.ClusterZookeeperProperties;
import org.apache.shenyu.admin.mode.ShenyuRunningModeService;
import org.apache.shenyu.admin.mode.cluster.filter.ClusterForwardFilter;
import org.apache.shenyu.admin.mode.cluster.service.ClusterSelectMasterService;
import org.apache.shenyu.admin.mode.cluster.service.ShenyuClusterService;
import org.apache.shenyu.admin.service.impl.InstanceCheckService;
import org.apache.shenyu.admin.service.impl.UpstreamCheckService;
import org.apache.shenyu.admin.service.manager.LoadServiceDocEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={ClusterProperties.class, ClusterZookeeperProperties.class})
@ConditionalOnProperty(value={"shenyu.cluster.enabled"}, havingValue="true", matchIfMissing=false)
public class ClusterConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterConfiguration.class);

    @Bean(destroyMethod="shutdown")
    @ConditionalOnMissingBean
    public ShenyuRunningModeService shenyuRunningModeService(ClusterSelectMasterService shenyuClusterSelectMasterService, UpstreamCheckService upstreamCheckService, InstanceCheckService instanceCheckService, LoadServiceDocEntry loadServiceDocEntry, ClusterProperties clusterProperties) {
        LOGGER.info("starting in cluster mode ...");
        return new ShenyuClusterService(shenyuClusterSelectMasterService, upstreamCheckService, instanceCheckService, loadServiceDocEntry, clusterProperties);
    }

    @Bean
    public ClusterForwardFilter clusterForwardFilter(ClusterProperties clusterProperties) {
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        factory.setConnectTimeout(clusterProperties.getConnectionTimeout());
        factory.setReadTimeout(clusterProperties.getReadTimeout());
        return new ClusterForwardFilter(new RestTemplate((ClientHttpRequestFactory)factory));
    }
}

