/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.core.utils;

import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.exception.ShenyuException;
import org.springframework.beans.factory.BeanFactory;

public class PortUtils {
    public static int findPort(BeanFactory beanFactory) {
        try {
            return PortUtils.getPort(beanFactory, "org.springframework.boot.web.server.AbstractConfigurableWebServerFactory");
        }
        catch (Exception exception) {
            try {
                return PortUtils.getPort(beanFactory, "org.springframework.boot.context.embedded.AbstractConfigurableEmbeddedServletContainer");
            }
            catch (Exception exception2) {
                try {
                    return PortUtils.getPort();
                }
                catch (Exception e) {
                    throw new ShenyuException("can not find port automatically ! ");
                }
            }
        }
    }

    private static int getPort(BeanFactory beanFactory, String className) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> clazz = Class.forName(className);
        Method method = clazz.getMethod("getPort", new Class[0]);
        Object bean = beanFactory.getBean(clazz);
        return (Integer)method.invoke(bean, new Object[0]);
    }

    public static Integer getPort() throws Exception {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> objectNames = mBeanServer.queryNames(new ObjectName("*:type=Connector,*"), null);
        if (CollectionUtils.isEmpty(objectNames)) {
            throw new IllegalStateException("Cannot get the names of MBeans controlled by the MBean server.");
        }
        if (objectNames.size() > 1) {
            throw new IllegalStateException("Not supported when there are multiple instances of external Tomcat.");
        }
        ObjectName objectName = objectNames.iterator().next();
        String protocol = String.valueOf(mBeanServer.getAttribute(objectName, "protocol"));
        String port = String.valueOf(mBeanServer.getAttribute(objectName, "port"));
        if ("HTTP/1.1".equals(protocol) || "org.apache.coyote.http11.Http11NioProtocol".equals(protocol)) {
            return Integer.parseInt(port);
        }
        throw new IllegalStateException("failed to get the HTTP port of the current tomcat");
    }
}

