/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.registry.kubernetes;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.shenyu.registry.api.ShenyuInstanceRegisterRepository;
import org.apache.shenyu.registry.api.config.RegisterConfig;
import org.apache.shenyu.registry.api.entity.InstanceEntity;
import org.apache.shenyu.registry.kubernetes.KubernetesClient;
import org.apache.shenyu.registry.kubernetes.KubernetesConfig;
import org.apache.shenyu.registry.kubernetes.KubernetesInstance;
import org.apache.shenyu.spi.Join;

@Join(isSingleton=false)
public class KubernetesInstanceRegisterRepository
implements ShenyuInstanceRegisterRepository {
    private KubernetesClient kubernetesClient;

    public void init(RegisterConfig config) {
        Properties properties = config.getProps();
        KubernetesConfig kubernetesConfig = new KubernetesConfig();
        kubernetesConfig.setDiscoveryServerUrl(config.getServerLists());
        kubernetesConfig.setEnabled(config.getEnabled());
        kubernetesConfig.setNamespaces(Arrays.asList(properties.getProperty("namespaces").split(",")));
        this.kubernetesClient = new KubernetesClient(kubernetesConfig);
    }

    public void persistInstance(InstanceEntity instance) {
    }

    public List<InstanceEntity> selectInstances(String selectKey) {
        List<KubernetesInstance> instanceList = this.kubernetesClient.selectInstances(selectKey);
        return instanceList.stream().map(instance -> InstanceEntity.builder().appName(instance.getServiceId()).host(instance.getHost()).port(Integer.valueOf(instance.getPort())).uri(this.getURI((KubernetesInstance)instance)).build()).collect(Collectors.toList());
    }

    private URI getURI(KubernetesInstance instance) {
        boolean secure = instance.isSecure();
        String scheme = secure ? "https" : "http";
        int port = instance.getPort();
        if (port <= 0) {
            port = secure ? 443 : 80;
        }
        String uri = String.format("%s://%s:%s", scheme, instance.getHost(), port);
        return URI.create(uri);
    }

    public void close() {
        super.close();
    }
}

