/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.models;

import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;

public class MethodAttributes {
    private final String defaultConsumesMediaType;
    private final String defaultProducesMediaType;
    private final LinkedHashMap<String, String> headers = new LinkedHashMap();
    private final Locale locale;
    private boolean methodOverloaded;
    private boolean withApiResponseDoc;
    private boolean withResponseBodySchemaDoc;
    private JsonView jsonViewAnnotation;
    private JsonView jsonViewAnnotationForRequestBody;
    private String[] classProduces;
    private String[] classConsumes;
    private String[] methodProduces = new String[0];
    private String[] methodConsumes = new String[0];
    private Map<String, ApiResponse> genericMapResponse = new LinkedHashMap<String, ApiResponse>();
    private String javadocReturn;

    public MethodAttributes(String[] methodProducesNew, String defaultConsumesMediaType, String defaultProducesMediaType, Map<String, ApiResponse> genericMapResponse, Locale locale) {
        this.methodProduces = methodProducesNew;
        this.defaultConsumesMediaType = defaultConsumesMediaType;
        this.defaultProducesMediaType = defaultProducesMediaType;
        this.genericMapResponse = genericMapResponse;
        this.locale = locale;
    }

    public MethodAttributes(String defaultConsumesMediaType, String defaultProducesMediaType, Locale locale) {
        this.defaultConsumesMediaType = defaultConsumesMediaType;
        this.defaultProducesMediaType = defaultProducesMediaType;
        this.locale = locale;
    }

    public MethodAttributes(String defaultConsumesMediaType, String defaultProducesMediaType, String[] methodConsumes, String[] methodProduces, String[] headers, Locale locale) {
        this.defaultConsumesMediaType = defaultConsumesMediaType;
        this.defaultProducesMediaType = defaultProducesMediaType;
        this.methodProduces = methodProduces;
        this.methodConsumes = methodConsumes;
        this.locale = locale;
        this.setHeaders(headers);
    }

    public String[] getClassProduces() {
        return this.classProduces;
    }

    public void setClassProduces(String[] classProduces) {
        this.classProduces = classProduces;
    }

    public String[] getClassConsumes() {
        return this.classConsumes;
    }

    public void setClassConsumes(String[] classConsumes) {
        this.classConsumes = classConsumes;
    }

    public String[] getMethodProduces() {
        return this.methodProduces;
    }

    public String[] getMethodConsumes() {
        return this.methodConsumes;
    }

    public void calculateConsumesProduces(Method method) {
        PostMapping reqPostMappingMethod = (PostMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, PostMapping.class);
        if (reqPostMappingMethod != null) {
            this.fillMethods(reqPostMappingMethod.produces(), reqPostMappingMethod.consumes(), reqPostMappingMethod.headers());
            return;
        }
        GetMapping reqGetMappingMethod = (GetMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, GetMapping.class);
        if (reqGetMappingMethod != null) {
            this.fillMethods(reqGetMappingMethod.produces(), reqGetMappingMethod.consumes(), reqGetMappingMethod.headers());
            return;
        }
        DeleteMapping reqDeleteMappingMethod = (DeleteMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, DeleteMapping.class);
        if (reqDeleteMappingMethod != null) {
            this.fillMethods(reqDeleteMappingMethod.produces(), reqDeleteMappingMethod.consumes(), reqDeleteMappingMethod.headers());
            return;
        }
        PutMapping reqPutMappingMethod = (PutMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, PutMapping.class);
        if (reqPutMappingMethod != null) {
            this.fillMethods(reqPutMappingMethod.produces(), reqPutMappingMethod.consumes(), reqPutMappingMethod.headers());
            return;
        }
        RequestMapping reqMappingMethod = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, RequestMapping.class);
        RequestMapping reqMappingClass = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation(method.getDeclaringClass(), RequestMapping.class);
        if (reqMappingMethod != null && reqMappingClass != null) {
            this.fillMethods((String[])ArrayUtils.addAll((Object[])reqMappingMethod.produces(), (Object[])reqMappingClass.produces()), (String[])ArrayUtils.addAll((Object[])reqMappingMethod.consumes(), (Object[])reqMappingClass.consumes()), reqMappingMethod.headers());
        } else if (reqMappingMethod != null) {
            this.fillMethods(reqMappingMethod.produces(), reqMappingMethod.consumes(), reqMappingMethod.headers());
        } else if (reqMappingClass != null) {
            this.fillMethods(reqMappingClass.produces(), reqMappingClass.consumes(), reqMappingClass.headers());
        } else {
            this.fillMethods(this.methodProduces, this.methodConsumes, null);
        }
    }

    private void fillMethods(String[] produces, String[] consumes, String[] headers) {
        if (ArrayUtils.isEmpty((Object[])this.methodProduces)) {
            this.methodProduces = ArrayUtils.isNotEmpty((Object[])produces) ? produces : (ArrayUtils.isNotEmpty((Object[])this.classProduces) ? this.classProduces : new String[]{this.defaultProducesMediaType});
        }
        if (ArrayUtils.isEmpty((Object[])this.methodConsumes)) {
            this.methodConsumes = ArrayUtils.isNotEmpty((Object[])consumes) ? consumes : (ArrayUtils.isNotEmpty((Object[])this.classConsumes) ? this.classConsumes : new String[]{this.defaultConsumesMediaType});
        }
        if (CollectionUtils.isEmpty(this.headers)) {
            this.setHeaders(headers);
        }
    }

    public boolean isMethodOverloaded() {
        return this.methodOverloaded;
    }

    public void setMethodOverloaded(boolean overloaded) {
        this.methodOverloaded = overloaded;
    }

    public void setWithApiResponseDoc(boolean withApiDoc) {
        this.withApiResponseDoc = withApiDoc;
    }

    public boolean isNoApiResponseDoc() {
        return !this.withApiResponseDoc;
    }

    public JsonView getJsonViewAnnotation() {
        return this.jsonViewAnnotation;
    }

    public void setJsonViewAnnotation(JsonView jsonViewAnnotation) {
        this.jsonViewAnnotation = jsonViewAnnotation;
    }

    public JsonView getJsonViewAnnotationForRequestBody() {
        if (this.jsonViewAnnotationForRequestBody == null) {
            return this.jsonViewAnnotation;
        }
        return this.jsonViewAnnotationForRequestBody;
    }

    public void setJsonViewAnnotationForRequestBody(JsonView jsonViewAnnotationForRequestBody) {
        this.jsonViewAnnotationForRequestBody = jsonViewAnnotationForRequestBody;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    private void setHeaders(String[] headers) {
        if (ArrayUtils.isNotEmpty((Object[])headers)) {
            for (String header : headers) {
                String[] keyValueHeader;
                if (!header.contains("!=")) {
                    keyValueHeader = header.split("=");
                    String headerValue = keyValueHeader.length > 1 ? keyValueHeader[1] : "";
                    this.headers.put(keyValueHeader[0], headerValue);
                    continue;
                }
                keyValueHeader = header.split("!=");
                if (this.headers.containsKey(keyValueHeader[0])) continue;
                this.headers.put(keyValueHeader[0], "");
            }
        }
    }

    public ApiResponses calculateGenericMapResponse(Map<String, ApiResponse> genericMapResponse) {
        ApiResponses apiResponses = new ApiResponses();
        genericMapResponse.forEach((arg_0, arg_1) -> ((ApiResponses)apiResponses).addApiResponse(arg_0, arg_1));
        this.genericMapResponse = genericMapResponse;
        return apiResponses;
    }

    public Map<String, ApiResponse> getGenericMapResponse() {
        return this.genericMapResponse;
    }

    public boolean isWithResponseBodySchemaDoc() {
        return this.withResponseBodySchemaDoc;
    }

    public void setWithResponseBodySchemaDoc(boolean withResponseBodySchemaDoc) {
        this.withResponseBodySchemaDoc = withResponseBodySchemaDoc;
    }

    public void calculateHeadersForClass(Class<?> declaringClass) {
        RequestMapping reqMappingClass = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation(declaringClass, RequestMapping.class);
        if (reqMappingClass != null) {
            this.fillMethods(reqMappingClass.produces(), reqMappingClass.consumes(), reqMappingClass.headers());
        }
    }

    public String getJavadocReturn() {
        return this.javadocReturn;
    }

    public void setJavadocReturn(String javadocReturn) {
        this.javadocReturn = javadocReturn;
    }

    public Locale getLocale() {
        return this.locale;
    }
}

