/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.impl;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import io.etcd.jetcd.Auth;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.api.AuthDisableRequest;
import io.etcd.jetcd.api.AuthEnableRequest;
import io.etcd.jetcd.api.AuthRoleAddRequest;
import io.etcd.jetcd.api.AuthRoleDeleteRequest;
import io.etcd.jetcd.api.AuthRoleGetRequest;
import io.etcd.jetcd.api.AuthRoleGrantPermissionRequest;
import io.etcd.jetcd.api.AuthRoleListRequest;
import io.etcd.jetcd.api.AuthRoleRevokePermissionRequest;
import io.etcd.jetcd.api.AuthUserAddRequest;
import io.etcd.jetcd.api.AuthUserChangePasswordRequest;
import io.etcd.jetcd.api.AuthUserDeleteRequest;
import io.etcd.jetcd.api.AuthUserGetRequest;
import io.etcd.jetcd.api.AuthUserGrantRoleRequest;
import io.etcd.jetcd.api.AuthUserListRequest;
import io.etcd.jetcd.api.AuthUserRevokeRoleRequest;
import io.etcd.jetcd.api.Permission;
import io.etcd.jetcd.api.VertxAuthGrpc;
import io.etcd.jetcd.auth.AuthDisableResponse;
import io.etcd.jetcd.auth.AuthEnableResponse;
import io.etcd.jetcd.auth.AuthRoleAddResponse;
import io.etcd.jetcd.auth.AuthRoleDeleteResponse;
import io.etcd.jetcd.auth.AuthRoleGetResponse;
import io.etcd.jetcd.auth.AuthRoleGrantPermissionResponse;
import io.etcd.jetcd.auth.AuthRoleListResponse;
import io.etcd.jetcd.auth.AuthRoleRevokePermissionResponse;
import io.etcd.jetcd.auth.AuthUserAddResponse;
import io.etcd.jetcd.auth.AuthUserChangePasswordResponse;
import io.etcd.jetcd.auth.AuthUserDeleteResponse;
import io.etcd.jetcd.auth.AuthUserGetResponse;
import io.etcd.jetcd.auth.AuthUserGrantRoleResponse;
import io.etcd.jetcd.auth.AuthUserListResponse;
import io.etcd.jetcd.auth.AuthUserRevokeRoleResponse;
import io.etcd.jetcd.auth.Permission;
import io.etcd.jetcd.impl.ClientConnectionManager;
import io.etcd.jetcd.impl.Impl;
import java.util.concurrent.CompletableFuture;

final class AuthImpl
extends Impl
implements Auth {
    private final VertxAuthGrpc.AuthVertxStub stub;

    AuthImpl(ClientConnectionManager connectionManager) {
        super(connectionManager);
        this.stub = connectionManager.newStub(VertxAuthGrpc::newVertxStub);
    }

    @Override
    public CompletableFuture<AuthEnableResponse> authEnable() {
        AuthEnableRequest enableRequest = AuthEnableRequest.getDefaultInstance();
        return this.completable(this.stub.authEnable(enableRequest), AuthEnableResponse::new);
    }

    @Override
    public CompletableFuture<AuthDisableResponse> authDisable() {
        AuthDisableRequest disableRequest = AuthDisableRequest.getDefaultInstance();
        return this.completable(this.stub.authDisable(disableRequest), AuthDisableResponse::new);
    }

    @Override
    public CompletableFuture<AuthUserAddResponse> userAdd(ByteSequence user, ByteSequence password) {
        Preconditions.checkNotNull((Object)user, (Object)"user can't be null");
        Preconditions.checkNotNull((Object)password, (Object)"password can't be null");
        AuthUserAddRequest addRequest = AuthUserAddRequest.newBuilder().setNameBytes(ByteString.copyFrom((byte[])user.getBytes())).setPasswordBytes(ByteString.copyFrom((byte[])password.getBytes())).build();
        return this.completable(this.stub.userAdd(addRequest), AuthUserAddResponse::new);
    }

    @Override
    public CompletableFuture<AuthUserDeleteResponse> userDelete(ByteSequence user) {
        Preconditions.checkNotNull((Object)user, (Object)"user can't be null");
        AuthUserDeleteRequest deleteRequest = AuthUserDeleteRequest.newBuilder().setNameBytes(ByteString.copyFrom((byte[])user.getBytes())).build();
        return this.completable(this.stub.userDelete(deleteRequest), AuthUserDeleteResponse::new);
    }

    @Override
    public CompletableFuture<AuthUserChangePasswordResponse> userChangePassword(ByteSequence user, ByteSequence password) {
        Preconditions.checkNotNull((Object)user, (Object)"user can't be null");
        Preconditions.checkNotNull((Object)password, (Object)"password can't be null");
        AuthUserChangePasswordRequest changePasswordRequest = AuthUserChangePasswordRequest.newBuilder().setNameBytes(ByteString.copyFrom((byte[])user.getBytes())).setPasswordBytes(ByteString.copyFrom((byte[])password.getBytes())).build();
        return this.completable(this.stub.userChangePassword(changePasswordRequest), AuthUserChangePasswordResponse::new);
    }

    @Override
    public CompletableFuture<AuthUserGetResponse> userGet(ByteSequence user) {
        Preconditions.checkNotNull((Object)user, (Object)"user can't be null");
        AuthUserGetRequest userGetRequest = AuthUserGetRequest.newBuilder().setNameBytes(ByteString.copyFrom((byte[])user.getBytes())).build();
        return this.completable(this.stub.userGet(userGetRequest), AuthUserGetResponse::new);
    }

    @Override
    public CompletableFuture<AuthUserListResponse> userList() {
        AuthUserListRequest userListRequest = AuthUserListRequest.getDefaultInstance();
        return this.completable(this.stub.userList(userListRequest), AuthUserListResponse::new);
    }

    @Override
    public CompletableFuture<AuthUserGrantRoleResponse> userGrantRole(ByteSequence user, ByteSequence role) {
        Preconditions.checkNotNull((Object)user, (Object)"user can't be null");
        Preconditions.checkNotNull((Object)role, (Object)"key can't be null");
        AuthUserGrantRoleRequest userGrantRoleRequest = AuthUserGrantRoleRequest.newBuilder().setUserBytes(ByteString.copyFrom((byte[])user.getBytes())).setRoleBytes(ByteString.copyFrom((byte[])role.getBytes())).build();
        return this.completable(this.stub.userGrantRole(userGrantRoleRequest), AuthUserGrantRoleResponse::new);
    }

    @Override
    public CompletableFuture<AuthUserRevokeRoleResponse> userRevokeRole(ByteSequence user, ByteSequence role) {
        Preconditions.checkNotNull((Object)user, (Object)"user can't be null");
        Preconditions.checkNotNull((Object)role, (Object)"key can't be null");
        AuthUserRevokeRoleRequest userRevokeRoleRequest = AuthUserRevokeRoleRequest.newBuilder().setNameBytes(ByteString.copyFrom((byte[])user.getBytes())).setRoleBytes(ByteString.copyFrom((byte[])role.getBytes())).build();
        return this.completable(this.stub.userRevokeRole(userRevokeRoleRequest), AuthUserRevokeRoleResponse::new);
    }

    @Override
    public CompletableFuture<AuthRoleAddResponse> roleAdd(ByteSequence user) {
        Preconditions.checkNotNull((Object)user, (Object)"user can't be null");
        AuthRoleAddRequest roleAddRequest = AuthRoleAddRequest.newBuilder().setNameBytes(ByteString.copyFrom((byte[])user.getBytes())).build();
        return this.completable(this.stub.roleAdd(roleAddRequest), AuthRoleAddResponse::new);
    }

    @Override
    public CompletableFuture<AuthRoleGrantPermissionResponse> roleGrantPermission(ByteSequence role, ByteSequence key, ByteSequence rangeEnd, Permission.Type permType) {
        Permission.Type type;
        Preconditions.checkNotNull((Object)role, (Object)"role can't be null");
        Preconditions.checkNotNull((Object)key, (Object)"key can't be null");
        Preconditions.checkNotNull((Object)rangeEnd, (Object)"rangeEnd can't be null");
        Preconditions.checkNotNull((Object)((Object)permType), (Object)"permType can't be null");
        switch (permType) {
            case WRITE: {
                type = Permission.Type.WRITE;
                break;
            }
            case READWRITE: {
                type = Permission.Type.READWRITE;
                break;
            }
            case READ: {
                type = Permission.Type.READ;
                break;
            }
            default: {
                type = Permission.Type.UNRECOGNIZED;
            }
        }
        Permission perm = Permission.newBuilder().setKey(ByteString.copyFrom((byte[])key.getBytes())).setRangeEnd(ByteString.copyFrom((byte[])rangeEnd.getBytes())).setPermType(type).build();
        AuthRoleGrantPermissionRequest roleGrantPermissionRequest = AuthRoleGrantPermissionRequest.newBuilder().setNameBytes(ByteString.copyFrom((byte[])role.getBytes())).setPerm(perm).build();
        return this.completable(this.stub.roleGrantPermission(roleGrantPermissionRequest), AuthRoleGrantPermissionResponse::new);
    }

    @Override
    public CompletableFuture<AuthRoleGetResponse> roleGet(ByteSequence role) {
        Preconditions.checkNotNull((Object)role, (Object)"role can't be null");
        AuthRoleGetRequest roleGetRequest = AuthRoleGetRequest.newBuilder().setRoleBytes(ByteString.copyFrom((byte[])role.getBytes())).build();
        return this.completable(this.stub.roleGet(roleGetRequest), AuthRoleGetResponse::new);
    }

    @Override
    public CompletableFuture<AuthRoleListResponse> roleList() {
        AuthRoleListRequest roleListRequest = AuthRoleListRequest.getDefaultInstance();
        return this.completable(this.stub.roleList(roleListRequest), AuthRoleListResponse::new);
    }

    @Override
    public CompletableFuture<AuthRoleRevokePermissionResponse> roleRevokePermission(ByteSequence role, ByteSequence key, ByteSequence rangeEnd) {
        Preconditions.checkNotNull((Object)role, (Object)"role can't be null");
        Preconditions.checkNotNull((Object)key, (Object)"key can't be null");
        Preconditions.checkNotNull((Object)rangeEnd, (Object)"rangeEnd can't be null");
        AuthRoleRevokePermissionRequest roleRevokePermissionRequest = AuthRoleRevokePermissionRequest.newBuilder().setRoleBytes(ByteString.copyFrom((byte[])role.getBytes())).setKeyBytes(ByteString.copyFrom((byte[])key.getBytes())).setRangeEndBytes(ByteString.copyFrom((byte[])rangeEnd.getBytes())).build();
        return this.completable(this.stub.roleRevokePermission(roleRevokePermissionRequest), AuthRoleRevokePermissionResponse::new);
    }

    @Override
    public CompletableFuture<AuthRoleDeleteResponse> roleDelete(ByteSequence role) {
        Preconditions.checkNotNull((Object)role, (Object)"role can't be null");
        AuthRoleDeleteRequest roleDeleteRequest = AuthRoleDeleteRequest.newBuilder().setRoleBytes(ByteString.copyFrom((byte[])role.getBytes())).build();
        return this.completable(this.stub.roleDelete(roleDeleteRequest), AuthRoleDeleteResponse::new);
    }
}

