/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.snapshot;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.CuratorCache;
import org.apache.shardingsphere.elasticjob.lite.internal.util.SensitiveInfoUtils;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.reg.zookeeper.ZookeeperRegistryCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SnapshotService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SnapshotService.class);
    public static final String DUMP_COMMAND = "dump@";
    private final int port;
    private final CoordinatorRegistryCenter regCenter;
    private ServerSocket serverSocket;
    private volatile boolean closed;

    public SnapshotService(CoordinatorRegistryCenter regCenter, int port) {
        Preconditions.checkArgument((port >= 0 && port <= 65535 ? 1 : 0) != 0, (Object)("Port value out of range: " + port));
        this.regCenter = regCenter;
        this.port = port;
    }

    public void listen() {
        try {
            log.info("ElasticJob: Snapshot service is running on port '{}'", (Object)this.openSocket(this.port));
        }
        catch (IOException ex) {
            log.error("ElasticJob: Snapshot service listen failure, error is: ", (Throwable)ex);
        }
    }

    private int openSocket(int port) throws IOException {
        this.serverSocket = new ServerSocket(port);
        int localPort = this.serverSocket.getLocalPort();
        String threadName = String.format("elasticjob-snapshot-service-%d", localPort);
        new Thread(() -> {
            while (!this.closed) {
                try {
                    this.process(this.serverSocket.accept());
                }
                catch (IOException ex) {
                    if (this.isIgnoredException()) {
                        return;
                    }
                    log.error("ElasticJob: Snapshot service open socket failure, error is: ", (Throwable)ex);
                }
            }
        }, threadName).start();
        return localPort;
    }

    private boolean isIgnoredException() {
        return this.serverSocket.isClosed();
    }

    private void process(Socket socket) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
             Socket ignored = socket;){
            String cmdLine = reader.readLine();
            if (null != cmdLine && cmdLine.startsWith(DUMP_COMMAND) && cmdLine.split("@").length == 2) {
                ArrayList<String> result = new ArrayList<String>();
                String jobName = cmdLine.split("@")[1];
                this.dumpDirectly("/" + jobName, jobName, result);
                this.outputMessage(writer, String.join((CharSequence)"\n", SensitiveInfoUtils.filterSensitiveIps(result)) + "\n");
            }
        }
    }

    private void dumpDirectly(String path, String jobName, List<String> result) {
        for (String each : this.regCenter.getChildrenKeys(path)) {
            CuratorCache cache;
            String zkPath = path + "/" + each;
            String zkValue = Optional.ofNullable(this.regCenter.get(zkPath)).orElse("");
            String cachePath = zkPath;
            String cacheValue = zkValue;
            if (this.regCenter instanceof ZookeeperRegistryCenter && null != (cache = (CuratorCache)this.regCenter.getRawCache("/" + jobName))) {
                Optional cacheData = cache.get(zkPath);
                cachePath = cacheData.map(ChildData::getPath).orElse("");
                cacheValue = cacheData.map(ChildData::getData).map(String::new).orElse("");
            }
            if (zkValue.equals(cacheValue) && zkPath.equals(cachePath)) {
                result.add(String.join((CharSequence)" | ", zkPath, zkValue));
            } else {
                result.add(String.join((CharSequence)" | ", zkPath, zkValue, cachePath, cacheValue));
            }
            this.dumpDirectly(zkPath, jobName, result);
        }
    }

    private void outputMessage(BufferedWriter outputWriter, String msg) throws IOException {
        outputWriter.append(msg);
        outputWriter.flush();
    }

    public void close() {
        this.closed = true;
        if (null != this.serverSocket && !this.serverSocket.isClosed()) {
            try {
                this.serverSocket.close();
            }
            catch (IOException ex) {
                log.error("ElasticJob: Snapshot service close failure, error is: ", (Throwable)ex);
            }
        }
    }
}

