/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.sharding;

import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.infra.yaml.YamlEngine;
import org.apache.shardingsphere.elasticjob.lite.internal.config.ConfigurationNode;
import org.apache.shardingsphere.elasticjob.lite.internal.config.ConfigurationService;
import org.apache.shardingsphere.elasticjob.lite.internal.instance.InstanceNode;
import org.apache.shardingsphere.elasticjob.lite.internal.listener.AbstractListenerManager;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.JobRegistry;
import org.apache.shardingsphere.elasticjob.lite.internal.server.ServerNode;
import org.apache.shardingsphere.elasticjob.lite.internal.sharding.ShardingService;
import org.apache.shardingsphere.elasticjob.lite.internal.storage.JobNodePath;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.reg.listener.DataChangedEvent;
import org.apache.shardingsphere.elasticjob.reg.listener.DataChangedEventListener;

public final class ShardingListenerManager
extends AbstractListenerManager {
    private final String jobName;
    private final ConfigurationNode configNode;
    private final InstanceNode instanceNode;
    private final ServerNode serverNode;
    private final ShardingService shardingService;
    private final JobNodePath jobNodePath;
    private final ConfigurationService configService;

    public ShardingListenerManager(CoordinatorRegistryCenter regCenter, String jobName) {
        super(regCenter, jobName);
        this.jobName = jobName;
        this.configNode = new ConfigurationNode(jobName);
        this.instanceNode = new InstanceNode(jobName);
        this.serverNode = new ServerNode(jobName);
        this.shardingService = new ShardingService(regCenter, jobName);
        this.jobNodePath = new JobNodePath(jobName);
        this.configService = new ConfigurationService(regCenter, jobName);
    }

    @Override
    public void start() {
        this.addDataListener(new ShardingTotalCountChangedJobListener());
        this.addDataListener(new ListenServersChangedJobListener());
    }

    class ShardingTotalCountChangedJobListener
    implements DataChangedEventListener {
        ShardingTotalCountChangedJobListener() {
        }

        public void onChange(DataChangedEvent event) {
            int newShardingTotalCount;
            if (ShardingListenerManager.this.configNode.isConfigPath(event.getKey()) && 0 != JobRegistry.getInstance().getCurrentShardingTotalCount(ShardingListenerManager.this.jobName) && (newShardingTotalCount = ((JobConfigurationPOJO)YamlEngine.unmarshal((String)event.getValue(), JobConfigurationPOJO.class)).toJobConfiguration().getShardingTotalCount()) != JobRegistry.getInstance().getCurrentShardingTotalCount(ShardingListenerManager.this.jobName)) {
                ShardingListenerManager.this.shardingService.setReshardingFlag();
                JobRegistry.getInstance().setCurrentShardingTotalCount(ShardingListenerManager.this.jobName, newShardingTotalCount);
            }
        }
    }

    class ListenServersChangedJobListener
    implements DataChangedEventListener {
        ListenServersChangedJobListener() {
        }

        public void onChange(DataChangedEvent event) {
            if (!(JobRegistry.getInstance().isShutdown(ShardingListenerManager.this.jobName) || !this.isInstanceChange(event.getType(), event.getKey()) && !this.isServerChange(event.getKey()) || this.isStaticSharding() && this.hasShardingInfo())) {
                ShardingListenerManager.this.shardingService.setReshardingFlag();
            }
        }

        private boolean isStaticSharding() {
            return ShardingListenerManager.this.configService.load(true).isStaticSharding();
        }

        private boolean hasShardingInfo() {
            return !JobRegistry.getInstance().getRegCenter(ShardingListenerManager.this.jobName).getChildrenKeys(ShardingListenerManager.this.jobNodePath.getShardingNodePath()).isEmpty();
        }

        private boolean isInstanceChange(DataChangedEvent.Type eventType, String path) {
            return ShardingListenerManager.this.instanceNode.isInstancePath(path) && DataChangedEvent.Type.UPDATED != eventType;
        }

        private boolean isServerChange(String path) {
            return ShardingListenerManager.this.serverNode.isServerPath(path);
        }
    }
}

