/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta.strats;

import java.util.HashMap;
import java.util.Map;
import org.apache.openjpa.jdbc.meta.strats.ColumnVersionStrategy;
import org.apache.openjpa.jdbc.schema.Column;

public class NumberVersionStrategy
extends ColumnVersionStrategy {
    private static final long serialVersionUID = 1L;
    public static final String ALIAS = "version-number";
    private Number _initial = 1;
    private Integer _javaType = null;

    public void setInitialValue(int initial) {
        this._initial = initial;
    }

    public int getInitialValue() {
        return this._initial.intValue();
    }

    @Override
    public String getAlias() {
        return ALIAS;
    }

    @Override
    protected int getJavaType() {
        if (this._javaType != null || this.vers.getClassMapping().getVersionFieldMapping() == null) {
            return 5;
        }
        this._javaType = this.vers.getClassMapping().getVersionFieldMapping().getTypeCode();
        return this._javaType;
    }

    @Override
    protected Object nextVersion(Object version) {
        if (version == null) {
            return this._initial;
        }
        return ((Number)version).intValue() + 1;
    }

    @Override
    public Map<Column, String> getBulkUpdateValues() {
        Column[] cols = this.vers.getColumns();
        HashMap<Column, String> map = new HashMap<Column, String>(cols.length);
        for (int i = 0; i < cols.length; ++i) {
            map.put(cols[i], cols[i].getName() + " + 1");
        }
        return map;
    }
}

