/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.generic.ClassGenException;
import org.aspectj.apache.bcel.generic.InvokeInstruction;

public final class INVOKEINTERFACE
extends InvokeInstruction {
    private int nargs;

    public INVOKEINTERFACE(int n, int n2, int n3) {
        super((short)185, n);
        if (n2 < 1) {
            throw new ClassGenException("Number of arguments must be > 0 " + n2);
        }
        this.nargs = n2;
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.opcode);
        dataOutputStream.writeShort(this.index);
        dataOutputStream.writeByte(this.nargs);
        dataOutputStream.writeByte(0);
    }

    public int getCount() {
        return this.nargs;
    }

    @Override
    public String toString(ConstantPool constantPool) {
        return super.toString(constantPool) + " " + this.nargs;
    }

    @Override
    public int consumeStack(ConstantPool constantPool) {
        return this.nargs;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof INVOKEINTERFACE)) {
            return false;
        }
        INVOKEINTERFACE iNVOKEINTERFACE = (INVOKEINTERFACE)object;
        return iNVOKEINTERFACE.opcode == this.opcode && iNVOKEINTERFACE.index == this.index && iNVOKEINTERFACE.nargs == this.nargs;
    }

    @Override
    public int hashCode() {
        return this.opcode * 37 + this.index * (this.nargs + 17);
    }
}

