/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import org.aspectj.apache.bcel.Constants;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.generic.FieldOrMethod;
import org.aspectj.apache.bcel.generic.Type;

public class FieldInstruction
extends FieldOrMethod {
    public FieldInstruction(short s, int n) {
        super(s, n);
    }

    @Override
    public String toString(ConstantPool constantPool) {
        return Constants.OPCODE_NAMES[this.opcode] + " " + constantPool.constantToString(this.index, (byte)9);
    }

    protected int getFieldSize(ConstantPool constantPool) {
        return Type.getTypeSize(this.getSignature(constantPool));
    }

    @Override
    public Type getType(ConstantPool constantPool) {
        return this.getFieldType(constantPool);
    }

    public Type getFieldType(ConstantPool constantPool) {
        return Type.getType(this.getSignature(constantPool));
    }

    public String getFieldName(ConstantPool constantPool) {
        return this.getName(constantPool);
    }

    @Override
    public int produceStack(ConstantPool constantPool) {
        if (!this.isStackProducer()) {
            return 0;
        }
        return this.getFieldSize(constantPool);
    }

    @Override
    public int consumeStack(ConstantPool constantPool) {
        if (!this.isStackConsumer()) {
            return 0;
        }
        if (this.opcode == 180) {
            return 1;
        }
        return this.getFieldSize(constantPool) + (this.opcode == 181 ? 1 : 0);
    }
}

