/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile.annotation;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.annotation.ElementValue;

public class ArrayElementValue
extends ElementValue {
    private static final ElementValue[] NO_VALUES = new ElementValue[0];
    private ElementValue[] evalues = NO_VALUES;

    public ElementValue[] getElementValuesArray() {
        return this.evalues;
    }

    public int getElementValuesArraySize() {
        return this.evalues.length;
    }

    public ArrayElementValue(ConstantPool constantPool) {
        super(91, constantPool);
    }

    public ArrayElementValue(int n, ElementValue[] elementValueArray, ConstantPool constantPool) {
        super(n, constantPool);
        if (n != 91) {
            throw new RuntimeException("Only element values of type array can be built with this ctor");
        }
        this.evalues = elementValueArray;
    }

    public ArrayElementValue(ArrayElementValue arrayElementValue, ConstantPool constantPool, boolean bl) {
        super(91, constantPool);
        this.evalues = new ElementValue[arrayElementValue.getElementValuesArraySize()];
        ElementValue[] elementValueArray = arrayElementValue.getElementValuesArray();
        for (int i = 0; i < elementValueArray.length; ++i) {
            this.evalues[i] = ElementValue.copy(elementValueArray[i], constantPool, bl);
        }
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.type);
        dataOutputStream.writeShort(this.evalues.length);
        for (int i = 0; i < this.evalues.length; ++i) {
            this.evalues[i].dump(dataOutputStream);
        }
    }

    @Override
    public String stringifyValue() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < this.evalues.length; ++i) {
            ElementValue elementValue = this.evalues[i];
            stringBuffer.append(elementValue.stringifyValue());
            if (i + 1 >= this.evalues.length) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void addElement(ElementValue elementValue) {
        ElementValue[] elementValueArray = this.evalues;
        this.evalues = new ElementValue[this.evalues.length + 1];
        System.arraycopy(elementValueArray, 0, this.evalues, 0, elementValueArray.length);
        this.evalues[elementValueArray.length] = elementValue;
    }
}

