/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.Constant;
import org.aspectj.apache.bcel.classfile.SimpleConstant;

public final class ConstantLong
extends Constant
implements SimpleConstant {
    private long longValue;

    public ConstantLong(long l) {
        super((byte)5);
        this.longValue = l;
    }

    ConstantLong(DataInputStream dataInputStream) throws IOException {
        this(dataInputStream.readLong());
    }

    @Override
    public void accept(ClassVisitor classVisitor) {
        classVisitor.visitConstantLong(this);
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.tag);
        dataOutputStream.writeLong(this.longValue);
    }

    @Override
    public final Long getValue() {
        return this.longValue;
    }

    @Override
    public final String getStringValue() {
        return Long.toString(this.longValue);
    }

    @Override
    public final String toString() {
        return super.toString() + "(longValue = " + this.longValue + ")";
    }
}

