/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.Constant;
import org.aspectj.apache.bcel.classfile.ConstantPool;

public abstract class ConstantCP
extends Constant {
    protected int classIndex;
    protected int nameAndTypeIndex;

    ConstantCP(byte by, DataInputStream dataInputStream) throws IOException {
        this(by, dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort());
    }

    protected ConstantCP(byte by, int n, int n2) {
        super(by);
        this.classIndex = n;
        this.nameAndTypeIndex = n2;
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.tag);
        dataOutputStream.writeShort(this.classIndex);
        dataOutputStream.writeShort(this.nameAndTypeIndex);
    }

    public final int getClassIndex() {
        return this.classIndex;
    }

    public final int getNameAndTypeIndex() {
        return this.nameAndTypeIndex;
    }

    public String getClass(ConstantPool constantPool) {
        return constantPool.constantToString(this.classIndex, (byte)7);
    }

    @Override
    public final String toString() {
        return super.toString() + "(classIndex = " + this.classIndex + ", nameAndTypeIndex = " + this.nameAndTypeIndex + ")";
    }
}

