/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.tracing.event;

import java.util.Date;
import java.util.UUID;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.tracing.event.JobEvent;

public final class JobExecutionEvent
implements JobEvent {
    private String id = UUID.randomUUID().toString();
    private final String hostname;
    private final String ip;
    private final String taskId;
    private final String jobName;
    private final ExecutionSource source;
    private final int shardingItem;
    private Date startTime = new Date();
    private Date completeTime;
    private boolean success;
    private String failureCause;

    public JobExecutionEvent executionSuccess() {
        JobExecutionEvent result = new JobExecutionEvent(this.id, this.hostname, this.ip, this.taskId, this.jobName, this.source, this.shardingItem, this.startTime, this.completeTime, this.success, this.failureCause);
        result.setCompleteTime(new Date());
        result.setSuccess(true);
        return result;
    }

    public JobExecutionEvent executionFailure(String failureCause) {
        JobExecutionEvent result = new JobExecutionEvent(this.id, this.hostname, this.ip, this.taskId, this.jobName, this.source, this.shardingItem, this.startTime, this.completeTime, this.success, failureCause);
        result.setCompleteTime(new Date());
        result.setSuccess(false);
        result.setFailureCause(failureCause);
        return result;
    }

    @Generated
    public JobExecutionEvent(String hostname, String ip, String taskId, String jobName, ExecutionSource source, int shardingItem) {
        this.hostname = hostname;
        this.ip = ip;
        this.taskId = taskId;
        this.jobName = jobName;
        this.source = source;
        this.shardingItem = shardingItem;
    }

    @Generated
    public JobExecutionEvent(String id, String hostname, String ip, String taskId, String jobName, ExecutionSource source, int shardingItem, Date startTime, Date completeTime, boolean success, String failureCause) {
        this.id = id;
        this.hostname = hostname;
        this.ip = ip;
        this.taskId = taskId;
        this.jobName = jobName;
        this.source = source;
        this.shardingItem = shardingItem;
        this.startTime = startTime;
        this.completeTime = completeTime;
        this.success = success;
        this.failureCause = failureCause;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Override
    @Generated
    public String getJobName() {
        return this.jobName;
    }

    @Generated
    public ExecutionSource getSource() {
        return this.source;
    }

    @Generated
    public int getShardingItem() {
        return this.shardingItem;
    }

    @Generated
    public Date getStartTime() {
        return this.startTime;
    }

    @Generated
    public Date getCompleteTime() {
        return this.completeTime;
    }

    @Generated
    public boolean isSuccess() {
        return this.success;
    }

    @Generated
    public String getFailureCause() {
        return this.failureCause;
    }

    @Generated
    public void setCompleteTime(Date completeTime) {
        this.completeTime = completeTime;
    }

    @Generated
    public void setSuccess(boolean success) {
        this.success = success;
    }

    @Generated
    public void setFailureCause(String failureCause) {
        this.failureCause = failureCause;
    }

    public static enum ExecutionSource {
        NORMAL_TRIGGER,
        MISFIRE,
        FAILOVER;

    }
}

