/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.CriteriaQueryParameterBinder;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.jpa.repository.query.JpaCountQueryCreator;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaQueryCreator;
import org.springframework.data.jpa.repository.query.JpaQueryExecution;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.ParameterMetadataProvider;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeJpaQuery
extends AbstractJpaQuery {
    private final Class<?> domainClass;
    private final PartTree tree;
    private final JpaParameters parameters;
    private final QueryPreparer query;
    private final QueryPreparer countQuery;
    private final EntityManager em;
    private final EscapeCharacter escape;

    public PartTreeJpaQuery(JpaQueryMethod method, EntityManager em, PersistenceProvider persistenceProvider, EscapeCharacter escape) {
        super(method, em);
        this.em = em;
        this.escape = escape;
        this.domainClass = method.getEntityInformation().getJavaType();
        this.parameters = method.getParameters();
        boolean recreationRequired = this.parameters.hasDynamicProjection() || this.parameters.potentiallySortsDynamically();
        try {
            this.tree = new PartTree(method.getName(), this.domainClass);
            this.countQuery = new CountQueryPreparer(persistenceProvider, recreationRequired);
            this.query = this.tree.isCountProjection() != false ? this.countQuery : new QueryPreparer(persistenceProvider, recreationRequired);
        }
        catch (Exception o_O) {
            throw new IllegalArgumentException(String.format("Failed to create query method %s! %s", new Object[]{method, o_O.getMessage()}), o_O);
        }
    }

    @Override
    public Query doCreateQuery(Object[] values) {
        return this.query.createQuery(values);
    }

    public TypedQuery<Long> doCreateCountQuery(Object[] values) {
        return (TypedQuery)this.countQuery.createQuery(values);
    }

    @Override
    protected JpaQueryExecution getExecution() {
        if (this.tree.isDelete().booleanValue()) {
            return new JpaQueryExecution.DeleteExecution(this.em);
        }
        if (this.tree.isExistsProjection().booleanValue()) {
            return new JpaQueryExecution.ExistsExecution();
        }
        return super.getExecution();
    }

    private class CountQueryPreparer
    extends QueryPreparer {
        public CountQueryPreparer(PersistenceProvider persistenceProvider, boolean recreateQueries) {
            super(persistenceProvider, recreateQueries);
        }

        @Override
        protected JpaQueryCreator createCreator(ParametersParameterAccessor accessor, PersistenceProvider persistenceProvider) {
            EntityManager entityManager = PartTreeJpaQuery.this.getEntityManager();
            CriteriaBuilder builder = entityManager.getCriteriaBuilder();
            ParameterMetadataProvider provider = accessor == null ? new ParameterMetadataProvider(builder, PartTreeJpaQuery.this.parameters, persistenceProvider, PartTreeJpaQuery.this.escape) : new ParameterMetadataProvider(builder, accessor, persistenceProvider, PartTreeJpaQuery.this.escape);
            return new JpaCountQueryCreator(PartTreeJpaQuery.this.tree, PartTreeJpaQuery.this.getQueryMethod().getResultProcessor().getReturnedType(), builder, provider);
        }

        @Override
        protected Query invokeBinding(ParameterBinder binder, TypedQuery<?> query) {
            return binder.bind(query);
        }
    }

    private class QueryPreparer {
        private final CriteriaQuery<?> cachedCriteriaQuery;
        private final List<ParameterMetadataProvider.ParameterMetadata<?>> expressions;
        private final PersistenceProvider persistenceProvider;

        public QueryPreparer(PersistenceProvider persistenceProvider, boolean recreateQueries) {
            this.persistenceProvider = persistenceProvider;
            JpaQueryCreator creator = this.createCreator(null, persistenceProvider);
            this.cachedCriteriaQuery = recreateQueries ? null : (CriteriaQuery)creator.createQuery();
            this.expressions = recreateQueries ? null : creator.getParameterExpressions();
        }

        public Query createQuery(Object[] values) {
            CriteriaQuery criteriaQuery = this.cachedCriteriaQuery;
            List<ParameterMetadataProvider.ParameterMetadata<?>> expressions = this.expressions;
            ParametersParameterAccessor accessor = new ParametersParameterAccessor((Parameters)PartTreeJpaQuery.this.parameters, values);
            if (this.cachedCriteriaQuery == null || accessor.hasBindableNullValue()) {
                JpaQueryCreator creator = this.createCreator(accessor, this.persistenceProvider);
                criteriaQuery = (CriteriaQuery)creator.createQuery(this.getDynamicSort(values));
                expressions = creator.getParameterExpressions();
            }
            TypedQuery<?> jpaQuery = this.createQuery(criteriaQuery);
            return this.restrictMaxResultsIfNecessary(this.invokeBinding(this.getBinder(values, expressions), jpaQuery));
        }

        private Query restrictMaxResultsIfNecessary(Query query) {
            if (PartTreeJpaQuery.this.tree.isLimiting()) {
                if (query.getMaxResults() != Integer.MAX_VALUE && query.getMaxResults() > PartTreeJpaQuery.this.tree.getMaxResults() && query.getFirstResult() > 0) {
                    query.setFirstResult(query.getFirstResult() - (query.getMaxResults() - PartTreeJpaQuery.this.tree.getMaxResults()));
                }
                query.setMaxResults(PartTreeJpaQuery.this.tree.getMaxResults().intValue());
            }
            if (PartTreeJpaQuery.this.tree.isExistsProjection().booleanValue()) {
                query.setMaxResults(1);
            }
            return query;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TypedQuery<?> createQuery(CriteriaQuery<?> criteriaQuery) {
            if (this.cachedCriteriaQuery != null) {
                CriteriaQuery<?> criteriaQuery2 = this.cachedCriteriaQuery;
                synchronized (criteriaQuery2) {
                    return PartTreeJpaQuery.this.getEntityManager().createQuery(criteriaQuery);
                }
            }
            return PartTreeJpaQuery.this.getEntityManager().createQuery(criteriaQuery);
        }

        protected JpaQueryCreator createCreator(ParametersParameterAccessor accessor, PersistenceProvider persistenceProvider) {
            EntityManager entityManager = PartTreeJpaQuery.this.getEntityManager();
            CriteriaBuilder builder = entityManager.getCriteriaBuilder();
            ParameterMetadataProvider provider = accessor == null ? new ParameterMetadataProvider(builder, PartTreeJpaQuery.this.parameters, persistenceProvider, PartTreeJpaQuery.this.escape) : new ParameterMetadataProvider(builder, accessor, persistenceProvider, PartTreeJpaQuery.this.escape);
            ResultProcessor resultFactory = PartTreeJpaQuery.this.getQueryMethod().getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
            return new JpaQueryCreator(PartTreeJpaQuery.this.tree, resultFactory.getReturnedType(), builder, provider);
        }

        protected Query invokeBinding(ParameterBinder binder, TypedQuery<?> query) {
            return binder.bindAndPrepare((Query)query);
        }

        private ParameterBinder getBinder(Object[] values, List<ParameterMetadataProvider.ParameterMetadata<?>> expressions) {
            return new CriteriaQueryParameterBinder(PartTreeJpaQuery.this.parameters, values, expressions);
        }

        private Sort getDynamicSort(Object[] values) {
            return PartTreeJpaQuery.this.parameters.potentiallySortsDynamically() ? new ParametersParameterAccessor((Parameters)PartTreeJpaQuery.this.parameters, values).getSort() : null;
        }
    }
}

