/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.generic.Instruction;
import org.aspectj.apache.bcel.generic.ReturnaddressType;
import org.aspectj.apache.bcel.generic.Type;

public class RET
extends Instruction {
    private boolean wide;
    private int index;

    public RET(int n, boolean bl) {
        super((short)169);
        this.index = n;
        this.wide = bl;
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        if (this.wide) {
            dataOutputStream.writeByte(196);
        }
        dataOutputStream.writeByte(this.opcode);
        if (this.wide) {
            dataOutputStream.writeShort(this.index);
        } else {
            dataOutputStream.writeByte(this.index);
        }
    }

    @Override
    public int getLength() {
        if (this.wide) {
            return 4;
        }
        return 2;
    }

    @Override
    public final int getIndex() {
        return this.index;
    }

    @Override
    public final void setIndex(int n) {
        this.index = n;
        this.wide = n > 255;
    }

    @Override
    public String toString(boolean bl) {
        return super.toString(bl) + " " + this.index;
    }

    @Override
    public Type getType(ConstantPool constantPool) {
        return ReturnaddressType.NO_TARGET;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof RET)) {
            return false;
        }
        RET rET = (RET)object;
        return rET.opcode == this.opcode && rET.index == this.index;
    }

    @Override
    public int hashCode() {
        return this.opcode * 37 + this.index;
    }
}

