/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.ui.service.producer;

import java.util.Optional;
import org.apache.shardingsphere.elasticjob.cloud.config.pojo.CloudJobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.cloud.ui.exception.AppConfigurationException;
import org.apache.shardingsphere.elasticjob.cloud.ui.service.app.CloudAppConfigurationService;
import org.apache.shardingsphere.elasticjob.cloud.ui.service.app.pojo.CloudAppConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.cloud.ui.service.job.CloudJobConfigurationService;
import org.apache.shardingsphere.elasticjob.cloud.ui.service.state.disable.job.DisableJobService;
import org.apache.shardingsphere.elasticjob.infra.exception.JobConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class ProducerManager {
    private static final Logger log = LoggerFactory.getLogger(ProducerManager.class);
    @Autowired
    private CloudAppConfigurationService appConfigService;
    @Autowired
    private CloudJobConfigurationService configService;
    @Autowired
    private DisableJobService disableJobService;

    public void register(CloudJobConfigurationPOJO cloudJobConfig) {
        if (this.disableJobService.isDisabled(cloudJobConfig.getJobName())) {
            throw new JobConfigurationException("Job '%s' has been disable.", new Object[]{cloudJobConfig.getJobName()});
        }
        Optional<CloudAppConfigurationPOJO> appConfigFromZk = this.appConfigService.load(cloudJobConfig.getAppName());
        if (!appConfigFromZk.isPresent()) {
            throw new AppConfigurationException("Register app '%s' firstly.", cloudJobConfig.getAppName());
        }
        Optional<CloudJobConfigurationPOJO> jobConfigFromZk = this.configService.load(cloudJobConfig.getJobName());
        if (jobConfigFromZk.isPresent()) {
            throw new JobConfigurationException("Job '%s' already existed.", new Object[]{cloudJobConfig.getJobName()});
        }
        this.configService.add(cloudJobConfig);
    }

    public void update(CloudJobConfigurationPOJO cloudJobConfig) {
        Optional<CloudJobConfigurationPOJO> jobConfigFromZk = this.configService.load(cloudJobConfig.getJobName());
        if (!jobConfigFromZk.isPresent()) {
            throw new JobConfigurationException("Cannot found job '%s', please register first.", new Object[]{cloudJobConfig.getJobName()});
        }
        this.configService.update(cloudJobConfig);
    }

    public void deregister(String jobName) {
        Optional<CloudJobConfigurationPOJO> jobConfig = this.configService.load(jobName);
        if (jobConfig.isPresent()) {
            this.disableJobService.remove(jobName);
            this.configService.remove(jobName);
        }
    }
}

