/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.ui.config;

import com.google.common.base.Strings;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.shardingsphere.elasticjob.tracing.api.TracingConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="event.trace")
public final class EventTraceConfiguration {
    private String rdbDriver;
    private String rdbUrl;
    private String rdbUsername;
    private String rdbPassword;

    public Optional<TracingConfiguration<DataSource>> getTracingConfiguration() {
        if (!(Strings.isNullOrEmpty((String)this.rdbDriver) || Strings.isNullOrEmpty((String)this.rdbUrl) || Strings.isNullOrEmpty((String)this.rdbUsername))) {
            BasicDataSource dataSource = new BasicDataSource();
            dataSource.setDriverClassName(this.rdbDriver);
            dataSource.setUrl(this.rdbUrl);
            dataSource.setUsername(this.rdbUsername);
            dataSource.setPassword(this.rdbPassword);
            return Optional.of(new TracingConfiguration("RDB", (Object)dataSource));
        }
        return Optional.empty();
    }

    public void setRdbDriver(String rdbDriver) {
        this.rdbDriver = rdbDriver;
    }

    public void setRdbUrl(String rdbUrl) {
        this.rdbUrl = rdbUrl;
    }

    public void setRdbUsername(String rdbUsername) {
        this.rdbUsername = rdbUsername;
    }

    public void setRdbPassword(String rdbPassword) {
        this.rdbPassword = rdbPassword;
    }
}

