/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.scheduler.mesos;

import com.netflix.fenzo.TaskScheduler;
import java.util.List;
import lombok.Generated;
import org.apache.mesos.Protos;
import org.apache.mesos.Scheduler;
import org.apache.mesos.SchedulerDriver;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.ha.FrameworkIDService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.mesos.FacadeService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.mesos.LeasesQueue;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.mesos.MesosStateService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.statistics.StatisticManager;
import org.apache.shardingsphere.elasticjob.infra.context.TaskContext;
import org.apache.shardingsphere.elasticjob.tracing.JobTracingEventBus;
import org.apache.shardingsphere.elasticjob.tracing.event.JobEvent;
import org.apache.shardingsphere.elasticjob.tracing.event.JobStatusTraceEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchedulerEngine
implements Scheduler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchedulerEngine.class);
    private final TaskScheduler taskScheduler;
    private final FacadeService facadeService;
    private final JobTracingEventBus jobTracingEventBus;
    private final FrameworkIDService frameworkIDService;
    private final StatisticManager statisticManager;

    public void registered(SchedulerDriver schedulerDriver, Protos.FrameworkID frameworkID, Protos.MasterInfo masterInfo) {
        log.info("call registered");
        this.frameworkIDService.save(frameworkID.getValue());
        this.taskScheduler.expireAllLeases();
        MesosStateService.register(masterInfo.getHostname(), masterInfo.getPort());
    }

    public void reregistered(SchedulerDriver schedulerDriver, Protos.MasterInfo masterInfo) {
        log.info("call reregistered");
        this.taskScheduler.expireAllLeases();
        MesosStateService.register(masterInfo.getHostname(), masterInfo.getPort());
    }

    public void resourceOffers(SchedulerDriver schedulerDriver, List<Protos.Offer> offers) {
        for (Protos.Offer offer : offers) {
            log.trace("Adding offer {} from host {}", (Object)offer.getId(), (Object)offer.getHostname());
            LeasesQueue.getInstance().offer(offer);
        }
    }

    public void offerRescinded(SchedulerDriver schedulerDriver, Protos.OfferID offerID) {
        log.trace("call offerRescinded: {}", (Object)offerID);
        this.taskScheduler.expireLease(offerID.getValue());
    }

    public void statusUpdate(SchedulerDriver schedulerDriver, Protos.TaskStatus taskStatus) {
        String taskId = taskStatus.getTaskId().getValue();
        TaskContext taskContext = TaskContext.from((String)taskId);
        String jobName = taskContext.getMetaInfo().getJobName();
        log.trace("call statusUpdate task state is: {}, task id is: {}", (Object)taskStatus.getState(), (Object)taskId);
        this.jobTracingEventBus.post((JobEvent)new JobStatusTraceEvent(jobName, taskContext.getId(), taskContext.getSlaveId(), JobStatusTraceEvent.Source.CLOUD_SCHEDULER, taskContext.getType().toString(), String.valueOf(taskContext.getMetaInfo().getShardingItems()), JobStatusTraceEvent.State.valueOf((String)taskStatus.getState().name()), taskStatus.getMessage()));
        switch (taskStatus.getState()) {
            case TASK_RUNNING: {
                if (!this.facadeService.load(jobName).isPresent()) {
                    schedulerDriver.killTask(Protos.TaskID.newBuilder().setValue(taskId).build());
                }
                if ("BEGIN".equals(taskStatus.getMessage())) {
                    this.facadeService.updateDaemonStatus(taskContext, false);
                    break;
                }
                if (!"COMPLETE".equals(taskStatus.getMessage())) break;
                this.facadeService.updateDaemonStatus(taskContext, true);
                this.statisticManager.taskRunSuccessfully();
                break;
            }
            case TASK_FINISHED: {
                this.facadeService.removeRunning(taskContext);
                this.unAssignTask(taskId);
                this.statisticManager.taskRunSuccessfully();
                break;
            }
            case TASK_KILLED: {
                log.warn("task id is: {}, status is: {}, message is: {}, source is: {}", new Object[]{taskId, taskStatus.getState(), taskStatus.getMessage(), taskStatus.getSource()});
                this.facadeService.removeRunning(taskContext);
                this.facadeService.addDaemonJobToReadyQueue(jobName);
                this.unAssignTask(taskId);
                break;
            }
            case TASK_LOST: 
            case TASK_DROPPED: 
            case TASK_GONE: 
            case TASK_GONE_BY_OPERATOR: 
            case TASK_FAILED: 
            case TASK_ERROR: {
                log.warn("task id is: {}, status is: {}, message is: {}, source is: {}", new Object[]{taskId, taskStatus.getState(), taskStatus.getMessage(), taskStatus.getSource()});
                this.facadeService.removeRunning(taskContext);
                this.facadeService.recordFailoverTask(taskContext);
                this.unAssignTask(taskId);
                this.statisticManager.taskRunFailed();
                break;
            }
            case TASK_UNKNOWN: 
            case TASK_UNREACHABLE: {
                log.error("task id is: {}, status is: {}, message is: {}, source is: {}", new Object[]{taskId, taskStatus.getState(), taskStatus.getMessage(), taskStatus.getSource()});
                this.statisticManager.taskRunFailed();
                break;
            }
        }
    }

    private void unAssignTask(String taskId) {
        String hostname = this.facadeService.popMapping(taskId);
        if (null != hostname) {
            this.taskScheduler.getTaskUnAssigner().call((Object)TaskContext.getIdForUnassignedSlave((String)taskId), (Object)hostname);
        }
    }

    public void frameworkMessage(SchedulerDriver schedulerDriver, Protos.ExecutorID executorID, Protos.SlaveID slaveID, byte[] bytes) {
        log.trace("call frameworkMessage slaveID: {}, bytes: {}", (Object)slaveID, (Object)new String(bytes));
    }

    public void disconnected(SchedulerDriver schedulerDriver) {
        log.warn("call disconnected");
        MesosStateService.deregister();
    }

    public void slaveLost(SchedulerDriver schedulerDriver, Protos.SlaveID slaveID) {
        log.warn("call slaveLost slaveID is: {}", (Object)slaveID);
        this.taskScheduler.expireAllLeasesByVMId(slaveID.getValue());
    }

    public void executorLost(SchedulerDriver schedulerDriver, Protos.ExecutorID executorID, Protos.SlaveID slaveID, int i) {
        log.warn("call executorLost slaveID is: {}, executorID is: {}", (Object)slaveID, (Object)executorID);
    }

    public void error(SchedulerDriver schedulerDriver, String message) {
        log.error("call error, message is: {}", (Object)message);
    }

    @Generated
    public SchedulerEngine(TaskScheduler taskScheduler, FacadeService facadeService, JobTracingEventBus jobTracingEventBus, FrameworkIDService frameworkIDService, StatisticManager statisticManager) {
        this.taskScheduler = taskScheduler;
        this.facadeService = facadeService;
        this.jobTracingEventBus = jobTracingEventBus;
        this.frameworkIDService = frameworkIDService;
        this.statisticManager = statisticManager;
    }
}

