/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.scheduler.config.job;

import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import lombok.Generated;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.CuratorCache;
import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.shardingsphere.elasticjob.cloud.config.CloudJobExecutionType;
import org.apache.shardingsphere.elasticjob.cloud.config.pojo.CloudJobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.producer.ProducerManager;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.state.ready.ReadyService;
import org.apache.shardingsphere.elasticjob.infra.yaml.YamlEngine;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CloudJobConfigurationListener
implements CuratorCacheListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CloudJobConfigurationListener.class);
    private final CoordinatorRegistryCenter regCenter;
    private final ProducerManager producerManager;
    private final ReadyService readyService;

    public CloudJobConfigurationListener(CoordinatorRegistryCenter regCenter, ProducerManager producerManager) {
        this.regCenter = regCenter;
        this.readyService = new ReadyService(regCenter);
        this.producerManager = producerManager;
    }

    public void event(CuratorCacheListener.Type type, ChildData oldData, ChildData data) {
        String path;
        String string = path = CuratorCacheListener.Type.NODE_DELETED == type ? oldData.getPath() : data.getPath();
        if (CuratorCacheListener.Type.NODE_CREATED == type && this.isJobConfigNode(path)) {
            CloudJobConfigurationPOJO cloudJobConfig = this.getCloudJobConfiguration(data);
            if (null != cloudJobConfig) {
                this.producerManager.schedule(cloudJobConfig);
            }
        } else if (CuratorCacheListener.Type.NODE_CHANGED == type && this.isJobConfigNode(path)) {
            CloudJobConfigurationPOJO cloudJobConfig = this.getCloudJobConfiguration(data);
            if (null == cloudJobConfig) {
                return;
            }
            if (CloudJobExecutionType.DAEMON == cloudJobConfig.getJobExecutionType()) {
                this.readyService.remove(Collections.singletonList(cloudJobConfig.getJobName()));
            }
            if (!cloudJobConfig.isMisfire()) {
                this.readyService.setMisfireDisabled(cloudJobConfig.getJobName());
            }
            this.producerManager.reschedule(cloudJobConfig.getJobName());
        } else if (CuratorCacheListener.Type.NODE_DELETED == type && this.isJobConfigNode(path)) {
            String jobName = path.substring("/config/job".length() + 1);
            this.producerManager.unschedule(jobName);
        }
    }

    private boolean isJobConfigNode(String path) {
        return path.startsWith("/config/job") && path.length() > "/config/job".length();
    }

    private CloudJobConfigurationPOJO getCloudJobConfiguration(ChildData data) {
        try {
            return (CloudJobConfigurationPOJO)YamlEngine.unmarshal((String)new String(data.getData()), CloudJobConfigurationPOJO.class);
        }
        catch (Exception ex) {
            log.warn("Wrong Cloud Job Configuration with:", (Throwable)ex);
            return null;
        }
    }

    public void start() {
        this.getCache().listenable().addListener((Object)this, (Executor)Executors.newSingleThreadExecutor());
    }

    public void stop() {
        this.getCache().listenable().removeListener((Object)this);
    }

    private CuratorCache getCache() {
        CuratorCache result = (CuratorCache)this.regCenter.getRawCache("/config/job");
        if (null != result) {
            return result;
        }
        this.regCenter.addCacheData("/config/job");
        return (CuratorCache)this.regCenter.getRawCache("/config/job");
    }
}

