/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.console.security;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.cloud.console.security.AuthenticationInfo;
import org.apache.shardingsphere.elasticjob.cloud.console.security.AuthenticationService;
import org.apache.shardingsphere.elasticjob.restful.Filter;
import org.apache.shardingsphere.elasticjob.restful.deserializer.RequestBodyDeserializer;
import org.apache.shardingsphere.elasticjob.restful.deserializer.RequestBodyDeserializerFactory;
import org.apache.shardingsphere.elasticjob.restful.filter.FilterChain;

public final class AuthenticationFilter
implements Filter {
    private final Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    private final AuthenticationService authenticationService;

    public void doFilter(FullHttpRequest httpRequest, FullHttpResponse httpResponse, FilterChain filterChain) {
        if (HttpMethod.POST.equals((Object)httpRequest.method()) && "/api/login".equals(httpRequest.uri())) {
            this.handleLogin(httpRequest, httpResponse);
            return;
        }
        String accessToken = httpRequest.headers().get("accessToken");
        if (Strings.isNullOrEmpty((String)accessToken) || !accessToken.equals(this.authenticationService.getToken())) {
            this.respondWithUnauthorized(httpResponse);
            return;
        }
        filterChain.next(httpRequest);
    }

    private void handleLogin(FullHttpRequest httpRequest, FullHttpResponse httpResponse) {
        byte[] bytes = ByteBufUtil.getBytes((ByteBuf)httpRequest.content());
        String mimeType = Optional.ofNullable(HttpUtil.getMimeType((HttpMessage)httpRequest)).orElseGet(() -> HttpUtil.getMimeType((CharSequence)"application/json; charset=utf-8")).toString();
        RequestBodyDeserializer deserializer = RequestBodyDeserializerFactory.getRequestBodyDeserializer((String)mimeType);
        AuthenticationInfo authenticationInfo = (AuthenticationInfo)deserializer.deserialize(AuthenticationInfo.class, bytes);
        boolean result = this.authenticationService.check(authenticationInfo);
        if (!result) {
            this.respondWithUnauthorized(httpResponse);
            return;
        }
        String token = this.gson.toJson(Collections.singletonMap("accessToken", this.authenticationService.getToken()));
        this.respond(httpResponse, HttpResponseStatus.OK, token.getBytes());
    }

    private void respondWithUnauthorized(FullHttpResponse httpResponse) {
        String result = this.gson.toJson(Collections.singletonMap("message", "Unauthorized."));
        this.respond(httpResponse, HttpResponseStatus.UNAUTHORIZED, result.getBytes());
    }

    private void respond(FullHttpResponse httpResponse, HttpResponseStatus status, byte[] result) {
        httpResponse.setStatus(status);
        httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json; charset=utf-8");
        httpResponse.content().writeBytes(result);
        HttpUtil.setContentLength((HttpMessage)httpResponse, (long)httpResponse.content().readableBytes());
        HttpUtil.setKeepAlive((HttpMessage)httpResponse, (boolean)true);
    }

    @Generated
    public AuthenticationFilter(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }
}

