/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo.queues;

import com.netflix.fenzo.VMResource;
import com.netflix.fenzo.queues.Assignable;
import com.netflix.fenzo.queues.QAttributes;
import com.netflix.fenzo.queues.QueuableTask;
import com.netflix.fenzo.queues.TaskQueue;
import com.netflix.fenzo.queues.TaskQueueException;
import com.netflix.fenzo.sla.ResAllocs;
import java.util.Collection;
import java.util.Map;

public interface UsageTrackedQueue {
    public void queueTask(QueuableTask var1) throws TaskQueueException;

    public Assignable<QueuableTask> nextTaskToLaunch() throws TaskQueueException;

    public void assignTask(QueuableTask var1) throws TaskQueueException;

    public boolean launchTask(QueuableTask var1) throws TaskQueueException;

    public QueuableTask removeTask(String var1, QAttributes var2) throws TaskQueueException;

    public void setTaskReadyTime(String var1, QAttributes var2, long var3) throws TaskQueueException;

    public double getDominantUsageShare();

    public void reset();

    public Map<TaskQueue.TaskState, Collection<QueuableTask>> getAllTasks() throws TaskQueueException;

    public void setTotalResources(Map<VMResource, Double> var1);

    public static class ResUsage {
        private final ResAllocs resAllocsWrapper = new ResAllocs(){

            @Override
            public String getTaskGroupName() {
                return "usage";
            }

            @Override
            public double getCores() {
                return cpus;
            }

            @Override
            public double getMemory() {
                return memory;
            }

            @Override
            public double getNetworkMbps() {
                return networkMbps;
            }

            @Override
            public double getDisk() {
                return disk;
            }
        };
        private double cpus = 0.0;
        private double memory = 0.0;
        private double networkMbps = 0.0;
        private double disk = 0.0;

        public void addUsage(QueuableTask task) {
            this.cpus += task.getCPUs();
            this.memory += task.getMemory();
            this.networkMbps += task.getNetworkMbps();
            this.disk += task.getDisk();
        }

        public void remUsage(QueuableTask task) {
            this.cpus -= task.getCPUs();
            this.memory -= task.getMemory();
            this.networkMbps -= task.getNetworkMbps();
            this.disk -= task.getDisk();
        }

        public ResAllocs getResAllocsWrapper() {
            return this.resAllocsWrapper;
        }

        public double getCpus() {
            return this.cpus;
        }

        public double getMemory() {
            return this.memory;
        }

        public double getNetworkMbps() {
            return this.networkMbps;
        }

        public double getDisk() {
            return this.disk;
        }

        public double getDominantResUsageFrom(ResAllocs totalResources) {
            double tCPU = totalResources.getCores();
            double max = tCPU > 0.0 ? this.cpus / tCPU : this.cpus;
            double tMemory = totalResources.getMemory();
            double tmp = tMemory > 0.0 ? this.memory / tMemory : this.memory;
            max = Math.max(max, tmp);
            double tNetwork = totalResources.getNetworkMbps();
            tmp = tNetwork > 0.0 ? this.networkMbps / tNetwork : this.networkMbps;
            max = Math.max(max, tmp);
            double tDisk = totalResources.getDisk();
            tmp = tDisk > 0.0 ? this.disk / tDisk : this.disk;
            max = Math.max(max, tmp);
            return max;
        }
    }
}

