/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo.plugins;

import com.netflix.fenzo.TaskRequest;
import com.netflix.fenzo.TaskTrackerState;
import com.netflix.fenzo.VMTaskFitnessCalculator;
import com.netflix.fenzo.VirtualMachineCurrentState;
import com.netflix.fenzo.plugins.BinPackingFitnessCalculators;

public class SpreadingFitnessCalculators {
    public static final VMTaskFitnessCalculator cpuSpreader = new VMTaskFitnessCalculator(){

        @Override
        public String getName() {
            return "CpuSpreader";
        }

        @Override
        public double calculateFitness(TaskRequest taskRequest, VirtualMachineCurrentState targetVM, TaskTrackerState taskTrackerState) {
            VMTaskFitnessCalculator cpuBinPacker = BinPackingFitnessCalculators.cpuBinPacker;
            return 1.0 - cpuBinPacker.calculateFitness(taskRequest, targetVM, taskTrackerState);
        }
    };
    public static final VMTaskFitnessCalculator memorySpreader = new VMTaskFitnessCalculator(){

        @Override
        public String getName() {
            return "MemorySpreader";
        }

        @Override
        public double calculateFitness(TaskRequest taskRequest, VirtualMachineCurrentState targetVM, TaskTrackerState taskTrackerState) {
            VMTaskFitnessCalculator memoryBinPacker = BinPackingFitnessCalculators.memoryBinPacker;
            return 1.0 - memoryBinPacker.calculateFitness(taskRequest, targetVM, taskTrackerState);
        }
    };
    public static final VMTaskFitnessCalculator networkSpreader = new VMTaskFitnessCalculator(){

        @Override
        public String getName() {
            return "NetworkSpreader";
        }

        @Override
        public double calculateFitness(TaskRequest taskRequest, VirtualMachineCurrentState targetVM, TaskTrackerState taskTrackerState) {
            VMTaskFitnessCalculator networkBinPacker = BinPackingFitnessCalculators.networkBinPacker;
            return 1.0 - networkBinPacker.calculateFitness(taskRequest, targetVM, taskTrackerState);
        }
    };
    public static final VMTaskFitnessCalculator cpuMemSpreader = new VMTaskFitnessCalculator(){

        @Override
        public String getName() {
            return "CpuAndMemorySpreader";
        }

        @Override
        public double calculateFitness(TaskRequest taskRequest, VirtualMachineCurrentState targetVM, TaskTrackerState taskTrackerState) {
            double cpuFitness = cpuSpreader.calculateFitness(taskRequest, targetVM, taskTrackerState);
            double memoryFitness = memorySpreader.calculateFitness(taskRequest, targetVM, taskTrackerState);
            return (cpuFitness + memoryFitness) / 2.0;
        }
    };
    public static final VMTaskFitnessCalculator cpuMemNetworkSpreader = new VMTaskFitnessCalculator(){

        @Override
        public String getName() {
            return "CPUAndMemoryAndNetworkBinPacker";
        }

        @Override
        public double calculateFitness(TaskRequest taskRequest, VirtualMachineCurrentState targetVM, TaskTrackerState taskTrackerState) {
            double cpuFitness = cpuSpreader.calculateFitness(taskRequest, targetVM, taskTrackerState);
            double memFitness = memorySpreader.calculateFitness(taskRequest, targetVM, taskTrackerState);
            double networkFitness = networkSpreader.calculateFitness(taskRequest, targetVM, taskTrackerState);
            return (cpuFitness + memFitness + networkFitness) / 3.0;
        }
    };
}

