/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo.plugins;

import com.netflix.fenzo.ScaleDownConstraintEvaluator;
import com.netflix.fenzo.VirtualMachineLease;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class BalancedScaleDownConstraintEvaluator
implements ScaleDownConstraintEvaluator<Map<String, Integer>> {
    private static final String FAILURE_GROUP = "failures";
    private final Function<VirtualMachineLease, String> keyExtractor;
    private final double initialScore;
    private final double initialStep;

    public BalancedScaleDownConstraintEvaluator(Function<VirtualMachineLease, String> keyExtractor, double initialScore, double initialStep) {
        this.keyExtractor = keyExtractor;
        this.initialScore = initialScore;
        this.initialStep = initialStep;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public ScaleDownConstraintEvaluator.Result<Map<String, Integer>> evaluate(VirtualMachineLease candidate, Optional<Map<String, Integer>> optionalContext) {
        Map context = optionalContext.orElseGet(HashMap::new);
        String group = this.findGroup(candidate);
        int groupCount = context.getOrDefault(group, 0);
        context.put(group, groupCount + 1);
        double score = this.computeScore(groupCount);
        return ScaleDownConstraintEvaluator.Result.of(score, context);
    }

    private double computeScore(int groupCount) {
        if (groupCount == 0) {
            return this.initialScore;
        }
        return this.initialScore + this.initialStep * (1.0 - Math.pow(0.5, groupCount)) / 0.5;
    }

    private String findGroup(VirtualMachineLease l) {
        String groupName;
        try {
            groupName = this.keyExtractor.apply(l);
        }
        catch (Exception e) {
            groupName = FAILURE_GROUP;
        }
        return groupName;
    }
}

