/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo.plugins;

import com.netflix.fenzo.ConstraintEvaluator;
import com.netflix.fenzo.TaskRequest;
import com.netflix.fenzo.TaskTracker;
import com.netflix.fenzo.TaskTrackerState;
import com.netflix.fenzo.VMTaskFitnessCalculator;
import com.netflix.fenzo.VirtualMachineCurrentState;
import com.netflix.fenzo.functions.Func1;
import com.netflix.fenzo.plugins.AttributeUtilities;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BalancedHostAttrConstraint
implements ConstraintEvaluator {
    private final String name;
    private final Func1<String, Set<String>> coTasksGetter;
    private final String hostAttributeName;
    private final int expectedValues;

    public BalancedHostAttrConstraint(Func1<String, Set<String>> coTasksGetter, String hostAttributeName, int expectedValues) {
        this.coTasksGetter = coTasksGetter;
        this.hostAttributeName = hostAttributeName;
        this.name = BalancedHostAttrConstraint.class.getName() + "-" + hostAttributeName;
        this.expectedValues = expectedValues;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ConstraintEvaluator.Result evaluate(TaskRequest taskRequest, VirtualMachineCurrentState targetVM, TaskTrackerState taskTrackerState) {
        Set<String> coTasks = this.coTasksGetter.call(taskRequest.getId());
        String targetHostAttrVal = AttributeUtilities.getAttrValue(targetVM.getCurrAvailableResources(), this.hostAttributeName);
        if (targetHostAttrVal == null || targetHostAttrVal.isEmpty()) {
            return new ConstraintEvaluator.Result(false, this.hostAttributeName + " attribute unavailable on host " + targetVM.getCurrAvailableResources().hostname());
        }
        Map<String, Integer> usedAttribsMap = null;
        try {
            usedAttribsMap = this.getUsedAttributesMap(coTasks, taskTrackerState);
        }
        catch (Exception e) {
            return new ConstraintEvaluator.Result(false, e.getMessage());
        }
        Integer integer = usedAttribsMap.get(targetHostAttrVal);
        if (integer == null || usedAttribsMap.isEmpty()) {
            return new ConstraintEvaluator.Result(true, "");
        }
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (Integer i : usedAttribsMap.values()) {
            min = Math.min(min, i);
            max = Math.max(max, i);
        }
        int n = min = this.expectedValues > usedAttribsMap.size() ? 0 : min;
        if (min == max || integer < max) {
            return new ConstraintEvaluator.Result(true, "");
        }
        return new ConstraintEvaluator.Result(false, "Would further imbalance by host attribute " + this.hostAttributeName);
    }

    private Map<String, Integer> getUsedAttributesMap(Set<String> coTasks, TaskTrackerState taskTrackerState) throws Exception {
        HashMap<String, Integer> usedAttribsMap = new HashMap<String, Integer>();
        for (String coTask : coTasks) {
            TaskTracker.ActiveTask activeTask = taskTrackerState.getAllRunningTasks().get(coTask);
            if (activeTask == null) {
                activeTask = taskTrackerState.getAllCurrentlyAssignedTasks().get(coTask);
            }
            if (activeTask == null) continue;
            String usedAttrVal = AttributeUtilities.getAttrValue(activeTask.getTotalLease(), this.hostAttributeName);
            if (usedAttrVal == null || usedAttrVal.isEmpty()) {
                throw new Exception(this.hostAttributeName + " attribute unavailable on host " + activeTask.getTotalLease().hostname() + " running co-task " + coTask);
            }
            if (usedAttribsMap.get(usedAttrVal) == null) {
                usedAttribsMap.put(usedAttrVal, 1);
                continue;
            }
            usedAttribsMap.put(usedAttrVal, (Integer)usedAttribsMap.get(usedAttrVal) + 1);
        }
        return usedAttribsMap;
    }

    public VMTaskFitnessCalculator asSoftConstraint() {
        return new VMTaskFitnessCalculator(){

            @Override
            public String getName() {
                return BalancedHostAttrConstraint.this.name;
            }

            @Override
            public double calculateFitness(TaskRequest taskRequest, VirtualMachineCurrentState targetVM, TaskTrackerState taskTrackerState) {
                String targetHostAttrVal = AttributeUtilities.getAttrValue(targetVM.getCurrAvailableResources(), BalancedHostAttrConstraint.this.hostAttributeName);
                if (targetHostAttrVal == null || targetHostAttrVal.isEmpty()) {
                    return 0.0;
                }
                Set coTasks = (Set)BalancedHostAttrConstraint.this.coTasksGetter.call(taskRequest.getId());
                Map usedAttribsMap = null;
                try {
                    usedAttribsMap = BalancedHostAttrConstraint.this.getUsedAttributesMap(coTasks, taskTrackerState);
                }
                catch (Exception e) {
                    return 0.0;
                }
                Integer integer = (Integer)usedAttribsMap.get(targetHostAttrVal);
                if (integer == null) {
                    return 1.0;
                }
                if (usedAttribsMap.isEmpty()) {
                    return 1.0;
                }
                double avg = 0.0;
                for (Integer i : usedAttribsMap.values()) {
                    avg += (double)i.intValue();
                }
                avg = Math.ceil(avg + (double)(1 / Math.max(BalancedHostAttrConstraint.this.expectedValues, usedAttribsMap.size())));
                if ((double)integer.intValue() <= avg) {
                    return (avg - (double)integer.intValue()) / avg;
                }
                return 0.0;
            }
        };
    }
}

