/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo;

import com.netflix.fenzo.AutoScaleRules;
import com.netflix.fenzo.BaseShortfallEvaluator;
import com.netflix.fenzo.TaskRequest;
import com.netflix.fenzo.queues.InternalTaskQueue;
import com.netflix.fenzo.queues.InternalTaskQueues;
import com.netflix.fenzo.queues.QueuableTask;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

class OptimizingShortfallEvaluator
extends BaseShortfallEvaluator {
    OptimizingShortfallEvaluator() {
    }

    @Override
    public Map<String, Integer> getShortfall(Set<String> vmGroupNames, Set<TaskRequest> failures, AutoScaleRules autoScaleRules) {
        if (this.schedulingService == null || failures == null || failures.isEmpty()) {
            return Collections.emptyMap();
        }
        List<TaskRequest> filteredTasks = this.filterFailedTasks(failures);
        Map<String, Integer> shortfallTasksPerGroup = this.fillShortfallMap(vmGroupNames, filteredTasks);
        if (shortfallTasksPerGroup.isEmpty()) {
            return Collections.emptyMap();
        }
        if (this.schedulingService.isShutdown()) {
            return Collections.emptyMap();
        }
        InternalTaskQueue taskQueue = this.createAndFillAlternateQueue(filteredTasks);
        return this.schedulingService.requestPseudoScheduling(taskQueue, shortfallTasksPerGroup);
    }

    private InternalTaskQueue createAndFillAlternateQueue(List<TaskRequest> shortfallTasks) {
        InternalTaskQueue taskQueue = InternalTaskQueues.createQueueOf(this.schedulingService.getQueue());
        for (TaskRequest t : shortfallTasks) {
            taskQueue.queueTask((QueuableTask)t);
        }
        return taskQueue;
    }
}

