/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo;

import com.netflix.fenzo.AssignableVirtualMachine;
import com.netflix.fenzo.VMResource;
import com.netflix.fenzo.VirtualMachineLease;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.mesos.Protos;

class InternalVMCloner {
    InternalVMCloner() {
    }

    VirtualMachineLease getClonedMaxResourcesLease(Collection<AssignableVirtualMachine> avms) {
        double cpus = 0.0;
        double mem = 0.0;
        double disk = 0.0;
        double network = 0.0;
        double ports = 0.0;
        final HashMap<String, Double> scalars = new HashMap<String, Double>();
        final HashMap<String, Protos.Attribute> attributeMap = new HashMap<String, Protos.Attribute>();
        if (avms != null) {
            for (AssignableVirtualMachine avm : avms) {
                Map<String, Protos.Attribute> attrs;
                Map<String, Double> maxScalars;
                Map<VMResource, Double> maxResources = avm.getMaxResources();
                Double value = maxResources.get((Object)VMResource.CPU);
                if (value != null) {
                    cpus = Math.max(cpus, value);
                }
                if ((value = maxResources.get((Object)VMResource.Memory)) != null) {
                    mem = Math.max(mem, value);
                }
                if ((value = maxResources.get((Object)VMResource.Disk)) != null) {
                    disk = Math.max(disk, value);
                }
                if ((value = maxResources.get((Object)VMResource.Network)) != null) {
                    network = Math.max(network, value);
                }
                if ((value = maxResources.get((Object)VMResource.Ports)) != null) {
                    ports = Math.max(ports, value);
                }
                if ((maxScalars = avm.getMaxScalars()) != null && !maxScalars.isEmpty()) {
                    for (String string : maxScalars.keySet()) {
                        scalars.compute(string, (s, oldVal) -> {
                            Double aDouble;
                            if (oldVal == null) {
                                oldVal = 0.0;
                            }
                            if ((aDouble = (Double)maxScalars.get(string)) == null) {
                                aDouble = 0.0;
                            }
                            return oldVal + aDouble;
                        });
                    }
                }
                if ((attrs = avm.getCurrTotalLease().getAttributeMap()) == null || attrs.isEmpty()) continue;
                for (Map.Entry<String, Protos.Attribute> e : attrs.entrySet()) {
                    attributeMap.putIfAbsent(e.getKey(), e.getValue());
                }
            }
        }
        final double fcpus = cpus;
        final double fmem = mem;
        final double fdisk = disk;
        final double d = network;
        final List<VirtualMachineLease.Range> fports = Collections.singletonList(new VirtualMachineLease.Range(100, 100 + (int)ports));
        return new VirtualMachineLease(){

            @Override
            public String getId() {
                return "NoID";
            }

            @Override
            public long getOfferedTime() {
                return 0L;
            }

            @Override
            public String hostname() {
                return "NoHostname";
            }

            @Override
            public String getVMID() {
                return "NoID";
            }

            @Override
            public double cpuCores() {
                return fcpus;
            }

            @Override
            public double memoryMB() {
                return fmem;
            }

            @Override
            public double networkMbps() {
                return d;
            }

            @Override
            public double diskMB() {
                return fdisk;
            }

            @Override
            public List<VirtualMachineLease.Range> portRanges() {
                return fports;
            }

            @Override
            public Protos.Offer getOffer() {
                return null;
            }

            @Override
            public Map<String, Protos.Attribute> getAttributeMap() {
                return attributeMap;
            }

            @Override
            public Double getScalarValue(String name) {
                return (Double)scalars.get(name);
            }

            @Override
            public Map<String, Double> getScalarValues() {
                return scalars;
            }
        };
    }

    VirtualMachineLease cloneLease(VirtualMachineLease lease, final String hostname, final long now) {
        final LinkedList<VirtualMachineLease.Range> ports = new LinkedList<VirtualMachineLease.Range>();
        List<VirtualMachineLease.Range> ranges = lease.portRanges();
        if (ranges != null && !ranges.isEmpty()) {
            for (VirtualMachineLease.Range r : ranges) {
                ports.add(new VirtualMachineLease.Range(r.getBeg(), r.getEnd()));
            }
        }
        final double cpus = lease.cpuCores();
        final double memory = lease.memoryMB();
        final double network = lease.networkMbps();
        final double disk = lease.diskMB();
        final HashMap<String, Protos.Attribute> attributes = new HashMap<String, Protos.Attribute>(lease.getAttributeMap());
        final HashMap<String, Double> scalarValues = new HashMap<String, Double>(lease.getScalarValues());
        return new VirtualMachineLease(){

            @Override
            public String getId() {
                return hostname;
            }

            @Override
            public long getOfferedTime() {
                return now;
            }

            @Override
            public String hostname() {
                return hostname;
            }

            @Override
            public String getVMID() {
                return hostname;
            }

            @Override
            public double cpuCores() {
                return cpus;
            }

            @Override
            public double memoryMB() {
                return memory;
            }

            @Override
            public double networkMbps() {
                return network;
            }

            @Override
            public double diskMB() {
                return disk;
            }

            @Override
            public List<VirtualMachineLease.Range> portRanges() {
                return ports;
            }

            @Override
            public Protos.Offer getOffer() {
                return null;
            }

            @Override
            public Map<String, Protos.Attribute> getAttributeMap() {
                return attributes;
            }

            @Override
            public Double getScalarValue(String name) {
                return (Double)scalarValues.get(name);
            }

            @Override
            public Map<String, Double> getScalarValues() {
                return scalarValues;
            }
        };
    }
}

