/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.executor.local;

import java.util.HashMap;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.api.ElasticJob;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.cloud.facade.CloudJobFacade;
import org.apache.shardingsphere.elasticjob.executor.ElasticJobExecutor;
import org.apache.shardingsphere.elasticjob.executor.JobFacade;
import org.apache.shardingsphere.elasticjob.infra.context.ShardingItemParameters;
import org.apache.shardingsphere.elasticjob.infra.listener.ShardingContexts;
import org.apache.shardingsphere.elasticjob.tracing.JobTracingEventBus;

public final class LocalTaskExecutor {
    private final ElasticJob elasticJob;
    private final String elasticJobType;
    private final JobConfiguration jobConfiguration;
    private final int shardingItem;

    public LocalTaskExecutor(ElasticJob elasticJob, JobConfiguration jobConfiguration, int shardingItem) {
        this(elasticJob, null, jobConfiguration, shardingItem);
    }

    public LocalTaskExecutor(String elasticJobType, JobConfiguration jobConfiguration, int shardingItem) {
        this(null, elasticJobType, jobConfiguration, shardingItem);
    }

    public void execute() {
        this.createElasticJobExecutor(new CloudJobFacade(this.getShardingContexts(), this.jobConfiguration, new JobTracingEventBus())).execute();
    }

    private ElasticJobExecutor createElasticJobExecutor(JobFacade jobFacade) {
        return null == this.elasticJob ? new ElasticJobExecutor(this.elasticJobType, this.jobConfiguration, jobFacade) : new ElasticJobExecutor(this.elasticJob, this.jobConfiguration, jobFacade);
    }

    private ShardingContexts getShardingContexts() {
        HashMap<Integer, String> shardingItemMap = new HashMap<Integer, String>(1, 1.0f);
        shardingItemMap.put(this.shardingItem, (String)new ShardingItemParameters(this.jobConfiguration.getShardingItemParameters()).getMap().get(this.shardingItem));
        String taskId = String.join((CharSequence)"@-@", this.jobConfiguration.getJobName(), this.shardingItem + "", "READY", "foo_slave_id", "foo_uuid");
        return new ShardingContexts(taskId, this.jobConfiguration.getJobName(), this.jobConfiguration.getShardingTotalCount(), this.jobConfiguration.getJobParameter(), shardingItemMap);
    }

    @Generated
    private LocalTaskExecutor(ElasticJob elasticJob, String elasticJobType, JobConfiguration jobConfiguration, int shardingItem) {
        this.elasticJob = elasticJob;
        this.elasticJobType = elasticJobType;
        this.jobConfiguration = jobConfiguration;
        this.shardingItem = shardingItem;
    }
}

