/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.migration;

import java.util.LinkedList;
import java.util.Optional;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.ConsistencyCheckJobItemProgressContext;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.PipelineDataConsistencyChecker;
import org.apache.shardingsphere.data.pipeline.core.context.TransmissionProcessContext;
import org.apache.shardingsphere.data.pipeline.core.job.config.PipelineJobConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.id.PipelineJobIdUtils;
import org.apache.shardingsphere.data.pipeline.core.job.progress.yaml.swapper.YamlTransmissionJobItemProgressSwapper;
import org.apache.shardingsphere.data.pipeline.core.job.service.PipelineJobConfigurationManager;
import org.apache.shardingsphere.data.pipeline.core.job.type.PipelineJobType;
import org.apache.shardingsphere.data.pipeline.core.pojo.PipelineJobInfo;
import org.apache.shardingsphere.data.pipeline.core.pojo.PipelineJobMetaData;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationJob;
import org.apache.shardingsphere.data.pipeline.scenario.migration.check.consistency.MigrationDataConsistencyChecker;
import org.apache.shardingsphere.data.pipeline.scenario.migration.config.MigrationJobConfiguration;
import org.apache.shardingsphere.data.pipeline.scenario.migration.config.yaml.swapper.YamlMigrationJobConfigurationSwapper;

public final class MigrationJobType
implements PipelineJobType {
    public String getCode() {
        return "01";
    }

    public boolean isTransmissionJob() {
        return true;
    }

    public YamlMigrationJobConfigurationSwapper getYamlJobConfigurationSwapper() {
        return new YamlMigrationJobConfigurationSwapper();
    }

    public YamlTransmissionJobItemProgressSwapper getYamlJobItemProgressSwapper() {
        return new YamlTransmissionJobItemProgressSwapper();
    }

    public Class<MigrationJob> getJobClass() {
        return MigrationJob.class;
    }

    public Optional<String> getToBeStartDisabledNextJobType() {
        return Optional.of("CONSISTENCY_CHECK");
    }

    public Optional<String> getToBeStoppedPreviousJobType() {
        return Optional.of("CONSISTENCY_CHECK");
    }

    public PipelineJobInfo getJobInfo(String jobId) {
        PipelineJobMetaData jobMetaData = new PipelineJobMetaData(PipelineJobIdUtils.getElasticJobConfigurationPOJO((String)jobId));
        LinkedList sourceTables = new LinkedList();
        ((MigrationJobConfiguration)new PipelineJobConfigurationManager((PipelineJobType)new MigrationJobType()).getJobConfiguration(jobId)).getJobShardingDataNodes().forEach(each -> each.getEntries().forEach(entry -> entry.getDataNodes().forEach(dataNode -> sourceTables.add(dataNode.format()))));
        return new PipelineJobInfo(jobMetaData, null, String.join((CharSequence)",", sourceTables));
    }

    public PipelineDataConsistencyChecker buildDataConsistencyChecker(PipelineJobConfiguration jobConfig, TransmissionProcessContext processContext, ConsistencyCheckJobItemProgressContext progressContext) {
        return new MigrationDataConsistencyChecker((MigrationJobConfiguration)jobConfig, processContext, progressContext);
    }

    public String getType() {
        return "MIGRATION";
    }
}

