/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.assignment;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptAssignmentToken;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptLiteralAssignmentToken;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptParameterAssignmentToken;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.infra.binder.context.segment.table.TablesContext;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.ColumnAssignmentSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;

public final class EncryptAssignmentTokenGenerator {
    private final EncryptRule rule;
    private final String databaseName;
    private final DatabaseType databaseType;

    public Collection<SQLToken> generateSQLTokens(TablesContext tablesContext, SetAssignmentSegment setAssignmentSegment) {
        String tableName = ((SimpleTableSegment)tablesContext.getSimpleTables().iterator().next()).getTableName().getIdentifier().getValue();
        EncryptTable encryptTable = this.rule.getEncryptTable(tableName);
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        String schemaName = tablesContext.getSchemaName().orElseGet(() -> new DatabaseTypeRegistry(this.databaseType).getDefaultSchemaName(this.databaseName));
        for (ColumnAssignmentSegment each : setAssignmentSegment.getAssignments()) {
            String columnName = ((ColumnSegment)each.getColumns().get(0)).getIdentifier().getValue();
            if (!encryptTable.isEncryptColumn(columnName)) continue;
            this.generateSQLToken(schemaName, encryptTable.getTable(), encryptTable.getEncryptColumn(columnName), each).ifPresent(result::add);
        }
        return result;
    }

    private Optional<EncryptAssignmentToken> generateSQLToken(String schemaName, String tableName, EncryptColumn encryptColumn, ColumnAssignmentSegment segment) {
        if (segment.getValue() instanceof ParameterMarkerExpressionSegment) {
            return Optional.of(this.generateParameterSQLToken(encryptColumn, segment));
        }
        if (segment.getValue() instanceof LiteralExpressionSegment) {
            return Optional.of(this.generateLiteralSQLToken(schemaName, tableName, encryptColumn, segment));
        }
        return Optional.empty();
    }

    private EncryptAssignmentToken generateParameterSQLToken(EncryptColumn encryptColumn, ColumnAssignmentSegment segment) {
        EncryptParameterAssignmentToken result = new EncryptParameterAssignmentToken(((ColumnSegment)segment.getColumns().get(0)).getStartIndex(), segment.getStopIndex(), ((ColumnSegment)segment.getColumns().get(0)).getIdentifier().getQuoteCharacter());
        result.addColumnName(encryptColumn.getCipher().getName());
        encryptColumn.getAssistedQuery().ifPresent(optional -> result.addColumnName(optional.getName()));
        encryptColumn.getLikeQuery().ifPresent(optional -> result.addColumnName(optional.getName()));
        return result;
    }

    private EncryptAssignmentToken generateLiteralSQLToken(String schemaName, String tableName, EncryptColumn encryptColumn, ColumnAssignmentSegment segment) {
        EncryptLiteralAssignmentToken result = new EncryptLiteralAssignmentToken(((ColumnSegment)segment.getColumns().get(0)).getStartIndex(), segment.getStopIndex(), ((ColumnSegment)segment.getColumns().get(0)).getIdentifier().getQuoteCharacter());
        this.addCipherAssignment(schemaName, tableName, encryptColumn, segment, result);
        this.addAssistedQueryAssignment(schemaName, tableName, encryptColumn, segment, result);
        this.addLikeAssignment(schemaName, tableName, encryptColumn, segment, result);
        return result;
    }

    private void addCipherAssignment(String schemaName, String tableName, EncryptColumn encryptColumn, ColumnAssignmentSegment segment, EncryptLiteralAssignmentToken token) {
        Object originalValue = ((LiteralExpressionSegment)segment.getValue()).getLiterals();
        Object cipherValue = encryptColumn.getCipher().encrypt(this.databaseName, schemaName, tableName, encryptColumn.getName(), Collections.singletonList(originalValue)).iterator().next();
        token.addAssignment(encryptColumn.getCipher().getName(), cipherValue);
    }

    private void addAssistedQueryAssignment(String schemaName, String tableName, EncryptColumn encryptColumn, ColumnAssignmentSegment segment, EncryptLiteralAssignmentToken token) {
        Object originalValue = ((LiteralExpressionSegment)segment.getValue()).getLiterals();
        if (encryptColumn.getAssistedQuery().isPresent()) {
            Object assistedQueryValue = encryptColumn.getAssistedQuery().get().encrypt(this.databaseName, schemaName, tableName, encryptColumn.getName(), Collections.singletonList(originalValue)).iterator().next();
            token.addAssignment(encryptColumn.getAssistedQuery().get().getName(), assistedQueryValue);
        }
    }

    private void addLikeAssignment(String schemaName, String tableName, EncryptColumn encryptColumn, ColumnAssignmentSegment segment, EncryptLiteralAssignmentToken token) {
        Object originalValue = ((LiteralExpressionSegment)segment.getValue()).getLiterals();
        if (encryptColumn.getLikeQuery().isPresent()) {
            Object assistedQueryValue = encryptColumn.getLikeQuery().get().encrypt(this.databaseName, schemaName, tableName, ((ColumnSegment)segment.getColumns().get(0)).getIdentifier().getValue(), Collections.singletonList(originalValue)).iterator().next();
            token.addAssignment(encryptColumn.getLikeQuery().get().getName(), assistedQueryValue);
        }
    }

    @Generated
    public EncryptAssignmentTokenGenerator(EncryptRule rule, String databaseName, DatabaseType databaseType) {
        this.rule = rule;
        this.databaseName = databaseName;
        this.databaseType = databaseType;
    }
}

