/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.executor.engine.pushdown.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.driver.executor.callback.add.StatementAddCallback;
import org.apache.shardingsphere.driver.executor.callback.execute.ExecuteQueryCallbackFactory;
import org.apache.shardingsphere.driver.executor.callback.replay.StatementReplayCallback;
import org.apache.shardingsphere.driver.jdbc.core.connection.ShardingSphereConnection;
import org.apache.shardingsphere.driver.jdbc.core.resultset.ShardingSphereResultSetFactory;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.connection.kernel.KernelProcessor;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroup;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupReportContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.process.ProcessEngine;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;
import org.apache.shardingsphere.infra.session.query.QueryContext;

public final class DriverJDBCPushDownExecuteQueryExecutor {
    private final ConnectionContext connectionContext;
    private final String processId;
    private final ShardingSphereMetaData metaData;
    private final ConfigurationProperties props;
    private final JDBCExecutor jdbcExecutor;
    private final Collection<Statement> statements;

    public DriverJDBCPushDownExecuteQueryExecutor(ShardingSphereConnection connection, ShardingSphereMetaData metaData, JDBCExecutor jdbcExecutor) {
        this.connectionContext = connection.getDatabaseConnectionManager().getConnectionContext();
        this.processId = connection.getProcessId();
        this.metaData = metaData;
        this.props = metaData.getProps();
        this.jdbcExecutor = jdbcExecutor;
        this.statements = new LinkedList<Statement>();
    }

    public ResultSet executeQuery(ShardingSphereDatabase database, QueryContext queryContext, DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, Statement statement, Map<String, Integer> columnLabelAndIndexMap, StatementAddCallback addCallback, StatementReplayCallback replayCallback) throws SQLException {
        List<QueryResult> queryResults = this.getQueryResults(database, queryContext, prepareEngine, addCallback, replayCallback);
        return new ShardingSphereResultSetFactory(this.connectionContext, this.metaData, this.props, this.statements).newInstance(database, queryContext, queryResults, statement, columnLabelAndIndexMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<QueryResult> getQueryResults(ShardingSphereDatabase database, QueryContext queryContext, DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, StatementAddCallback addCallback, StatementReplayCallback replayCallback) throws SQLException {
        this.statements.clear();
        ExecutionContext executionContext = new KernelProcessor().generateExecutionContext(queryContext, this.metaData.getGlobalRuleMetaData(), this.props);
        ExecutionGroupContext executionGroupContext = prepareEngine.prepare(database.getName(), executionContext.getRouteContext(), executionContext.getExecutionUnits(), new ExecutionGroupReportContext(this.processId, database.getName(), this.connectionContext.getGrantee()));
        for (ExecutionGroup each : executionGroupContext.getInputGroups()) {
            Collection<Statement> statements = this.getStatements((ExecutionGroup<JDBCExecutionUnit>)each);
            this.statements.addAll(statements);
            addCallback.add(statements, "JDBC.PREPARED_STATEMENT".equals(prepareEngine.getType()) ? this.getParameterSets((ExecutionGroup<JDBCExecutionUnit>)each) : Collections.emptyList());
        }
        replayCallback.replay();
        ProcessEngine processEngine = new ProcessEngine();
        try {
            processEngine.executeSQL(executionGroupContext, queryContext);
            List list = this.jdbcExecutor.execute(executionGroupContext, (JDBCExecutorCallback)new ExecuteQueryCallbackFactory(prepareEngine.getType()).newInstance(database, queryContext));
            return list;
        }
        finally {
            processEngine.completeSQLExecution(executionGroupContext.getReportContext().getProcessId());
        }
    }

    private Collection<Statement> getStatements(ExecutionGroup<JDBCExecutionUnit> executionGroup) {
        LinkedList<Statement> result = new LinkedList<Statement>();
        for (JDBCExecutionUnit each : executionGroup.getInputs()) {
            result.add(each.getStorageResource());
        }
        return result;
    }

    private Collection<List<Object>> getParameterSets(ExecutionGroup<JDBCExecutionUnit> executionGroup) {
        LinkedList<List<Object>> result = new LinkedList<List<Object>>();
        for (JDBCExecutionUnit each : executionGroup.getInputs()) {
            result.add(each.getExecutionUnit().getSqlUnit().getParameters());
        }
        return result;
    }
}

