/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.yaml.swapper;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.algorithm.core.yaml.YamlAlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.yaml.YamlAlgorithmConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapper;
import org.apache.shardingsphere.readwritesplitting.config.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.config.rule.ReadwriteSplittingDataSourceGroupRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.transaction.TransactionalReadQueryStrategy;
import org.apache.shardingsphere.readwritesplitting.yaml.config.YamlReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.yaml.config.rule.YamlReadwriteSplittingDataSourceGroupRuleConfiguration;

public final class YamlReadwriteSplittingRuleConfigurationSwapper
implements YamlRuleConfigurationSwapper<YamlReadwriteSplittingRuleConfiguration, ReadwriteSplittingRuleConfiguration> {
    private final YamlAlgorithmConfigurationSwapper algorithmSwapper = new YamlAlgorithmConfigurationSwapper();

    public YamlReadwriteSplittingRuleConfiguration swapToYamlConfiguration(ReadwriteSplittingRuleConfiguration data) {
        YamlReadwriteSplittingRuleConfiguration result = new YamlReadwriteSplittingRuleConfiguration();
        result.setDataSourceGroups(data.getDataSourceGroups().stream().collect(Collectors.toMap(ReadwriteSplittingDataSourceGroupRuleConfiguration::getName, this::swapToYamlConfiguration, (oldValue, currentValue) -> oldValue, LinkedHashMap::new)));
        if (null != data.getLoadBalancers()) {
            data.getLoadBalancers().forEach((key, value) -> result.getLoadBalancers().put((String)key, this.algorithmSwapper.swapToYamlConfiguration(value)));
        }
        return result;
    }

    private YamlReadwriteSplittingDataSourceGroupRuleConfiguration swapToYamlConfiguration(ReadwriteSplittingDataSourceGroupRuleConfiguration dataSourceGroupRuleConfig) {
        YamlReadwriteSplittingDataSourceGroupRuleConfiguration result = new YamlReadwriteSplittingDataSourceGroupRuleConfiguration();
        result.setWriteDataSourceName(dataSourceGroupRuleConfig.getWriteDataSourceName());
        if (null != dataSourceGroupRuleConfig.getReadDataSourceNames() && !dataSourceGroupRuleConfig.getReadDataSourceNames().isEmpty()) {
            result.setReadDataSourceNames(dataSourceGroupRuleConfig.getReadDataSourceNames());
        }
        result.setTransactionalReadQueryStrategy(dataSourceGroupRuleConfig.getTransactionalReadQueryStrategy().name());
        result.setLoadBalancerName(dataSourceGroupRuleConfig.getLoadBalancerName());
        return result;
    }

    public ReadwriteSplittingRuleConfiguration swapToObject(YamlReadwriteSplittingRuleConfiguration yamlConfig) {
        Collection dataSources = yamlConfig.getDataSourceGroups().entrySet().stream().map(entry -> this.swapToObject((String)entry.getKey(), (YamlReadwriteSplittingDataSourceGroupRuleConfiguration)entry.getValue())).collect(Collectors.toList());
        Map loadBalancerMap = null == yamlConfig.getLoadBalancers() ? Collections.emptyMap() : yamlConfig.getLoadBalancers().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.algorithmSwapper.swapToObject((YamlAlgorithmConfiguration)entry.getValue())));
        return new ReadwriteSplittingRuleConfiguration(dataSources, loadBalancerMap);
    }

    private ReadwriteSplittingDataSourceGroupRuleConfiguration swapToObject(String name, YamlReadwriteSplittingDataSourceGroupRuleConfiguration yamlDataSourceGroupRuleConfig) {
        return new ReadwriteSplittingDataSourceGroupRuleConfiguration(name, yamlDataSourceGroupRuleConfig.getWriteDataSourceName(), yamlDataSourceGroupRuleConfig.getReadDataSourceNames(), this.getTransactionalReadQueryStrategy(yamlDataSourceGroupRuleConfig), yamlDataSourceGroupRuleConfig.getLoadBalancerName());
    }

    private TransactionalReadQueryStrategy getTransactionalReadQueryStrategy(YamlReadwriteSplittingDataSourceGroupRuleConfiguration yamlDataSourceGroupRuleConfig) {
        return Strings.isNullOrEmpty((String)yamlDataSourceGroupRuleConfig.getTransactionalReadQueryStrategy()) ? TransactionalReadQueryStrategy.DYNAMIC : TransactionalReadQueryStrategy.valueOf((String)yamlDataSourceGroupRuleConfig.getTransactionalReadQueryStrategy());
    }

    public Class<ReadwriteSplittingRuleConfiguration> getTypeClass() {
        return ReadwriteSplittingRuleConfiguration.class;
    }

    public String getRuleTagName() {
        return "READWRITE_SPLITTING";
    }

    public int getOrder() {
        return 45;
    }
}

