/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.task;

import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.execute.PipelineExecuteEngine;
import org.apache.shardingsphere.data.pipeline.core.importer.Importer;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.Dumper;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.core.task.PipelineTask;
import org.apache.shardingsphere.data.pipeline.core.task.TaskExecuteCallback;
import org.apache.shardingsphere.data.pipeline.core.task.progress.InventoryTaskProgress;

public final class InventoryTask
implements PipelineTask {
    private final String taskId;
    private final PipelineExecuteEngine inventoryDumperExecuteEngine;
    private final PipelineExecuteEngine inventoryImporterExecuteEngine;
    private final Dumper dumper;
    private final Importer importer;
    private final AtomicReference<IngestPosition> position;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<CompletableFuture<?>> start() {
        LinkedList result = new LinkedList();
        PipelineExecuteEngine pipelineExecuteEngine = this.inventoryDumperExecuteEngine;
        synchronized (pipelineExecuteEngine) {
            result.add(this.inventoryDumperExecuteEngine.submit(this.dumper, new TaskExecuteCallback(this)));
            result.add(this.inventoryImporterExecuteEngine.submit(this.importer, new TaskExecuteCallback(this)));
        }
        return result;
    }

    @Override
    public void stop() {
        this.dumper.stop();
        this.importer.stop();
    }

    @Override
    public InventoryTaskProgress getTaskProgress() {
        return new InventoryTaskProgress(this.position.get());
    }

    @Generated
    public InventoryTask(String taskId, PipelineExecuteEngine inventoryDumperExecuteEngine, PipelineExecuteEngine inventoryImporterExecuteEngine, Dumper dumper, Importer importer, AtomicReference<IngestPosition> position) {
        this.taskId = taskId;
        this.inventoryDumperExecuteEngine = inventoryDumperExecuteEngine;
        this.inventoryImporterExecuteEngine = inventoryImporterExecuteEngine;
        this.dumper = dumper;
        this.importer = importer;
        this.position = position;
    }

    @Generated
    public String toString() {
        return "InventoryTask(taskId=" + this.getTaskId() + ", position=" + this.position + ")";
    }

    @Override
    @Generated
    public String getTaskId() {
        return this.taskId;
    }
}

