/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.sqlbuilder.sql;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.Column;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.DataRecord;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.dialect.DialectPipelineSQLBuilder;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.segment.PipelineSQLSegmentBuilder;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;

public final class PipelineImportSQLBuilder {
    private static final String INSERT_SQL_CACHE_KEY_PREFIX = "INSERT_";
    private static final String UPDATE_SQL_CACHE_KEY_PREFIX = "UPDATE_";
    private static final String DELETE_SQL_CACHE_KEY_PREFIX = "DELETE_";
    private final DialectPipelineSQLBuilder dialectSQLBuilder;
    private final PipelineSQLSegmentBuilder sqlSegmentBuilder;
    private final Cache<String, String> sqlCache;

    public PipelineImportSQLBuilder(DatabaseType databaseType) {
        this.dialectSQLBuilder = (DialectPipelineSQLBuilder)DatabaseTypedSPILoader.getService(DialectPipelineSQLBuilder.class, (DatabaseType)databaseType);
        this.sqlSegmentBuilder = new PipelineSQLSegmentBuilder(databaseType);
        this.sqlCache = Caffeine.newBuilder().initialCapacity(16).maximumSize(1024L).build();
    }

    public String buildInsertSQL(String schemaName, DataRecord dataRecord) {
        String sqlCacheKey = INSERT_SQL_CACHE_KEY_PREFIX + dataRecord.getTableName();
        if (null == this.sqlCache.getIfPresent((Object)sqlCacheKey)) {
            this.sqlCache.put((Object)sqlCacheKey, (Object)this.buildInsertSQL0(schemaName, dataRecord));
        }
        return (String)this.sqlCache.getIfPresent((Object)sqlCacheKey);
    }

    private String buildInsertSQL0(String schemaName, DataRecord dataRecord) {
        String insertMainClause = this.buildInsertMainClause(schemaName, dataRecord);
        return this.dialectSQLBuilder.buildInsertOnDuplicateClause(dataRecord).map(optional -> insertMainClause + " " + optional).orElse(insertMainClause);
    }

    private String buildInsertMainClause(String schemaName, DataRecord dataRecord) {
        String columnsLiteral = dataRecord.getColumns().stream().map(each -> this.sqlSegmentBuilder.getEscapedIdentifier(each.getName())).collect(Collectors.joining(","));
        String valuesLiteral = dataRecord.getColumns().stream().map(each -> "?").collect(Collectors.joining(","));
        return String.format("INSERT INTO %s(%s) VALUES(%s)", this.sqlSegmentBuilder.getQualifiedTableName(schemaName, dataRecord.getTableName()), columnsLiteral, valuesLiteral);
    }

    public String buildUpdateSQL(String schemaName, DataRecord dataRecord, Collection<Column> conditionColumns) {
        String sqlCacheKey = UPDATE_SQL_CACHE_KEY_PREFIX + dataRecord.getTableName();
        if (null == this.sqlCache.getIfPresent((Object)sqlCacheKey)) {
            this.sqlCache.put((Object)sqlCacheKey, (Object)this.buildUpdateSQL0(schemaName, dataRecord, conditionColumns));
        }
        Collection setColumns = dataRecord.getColumns().stream().filter(Column::isUpdated).collect(Collectors.toList());
        String updateSetClause = setColumns.stream().map(each -> this.sqlSegmentBuilder.getEscapedIdentifier(each.getName()) + " = ?").collect(Collectors.joining(","));
        return String.format(Objects.requireNonNull((String)this.sqlCache.getIfPresent((Object)sqlCacheKey)), updateSetClause);
    }

    private String buildUpdateSQL0(String schemaName, DataRecord dataRecord, Collection<Column> conditionColumns) {
        String updateMainClause = String.format("UPDATE %s SET %%s", this.sqlSegmentBuilder.getQualifiedTableName(schemaName, dataRecord.getTableName()));
        return this.buildWhereClause(conditionColumns).map(optional -> updateMainClause + optional).orElse(updateMainClause);
    }

    public String buildDeleteSQL(String schemaName, DataRecord dataRecord, Collection<Column> conditionColumns) {
        String sqlCacheKey = DELETE_SQL_CACHE_KEY_PREFIX + dataRecord.getTableName();
        if (null == this.sqlCache.getIfPresent((Object)sqlCacheKey)) {
            this.sqlCache.put((Object)sqlCacheKey, (Object)this.buildDeleteSQL0(schemaName, dataRecord, conditionColumns));
        }
        return (String)this.sqlCache.getIfPresent((Object)sqlCacheKey);
    }

    private String buildDeleteSQL0(String schemaName, DataRecord dataRecord, Collection<Column> conditionColumns) {
        String deleteMainClause = this.buildDeleteMainClause(schemaName, dataRecord);
        return this.buildWhereClause(conditionColumns).map(optional -> deleteMainClause + optional).orElse(deleteMainClause);
    }

    private String buildDeleteMainClause(String schemaName, DataRecord dataRecord) {
        return String.format("DELETE FROM %s", this.sqlSegmentBuilder.getQualifiedTableName(schemaName, dataRecord.getTableName()));
    }

    private Optional<String> buildWhereClause(Collection<Column> conditionColumns) {
        return conditionColumns.isEmpty() ? Optional.empty() : Optional.of(" WHERE " + conditionColumns.stream().map(each -> this.sqlSegmentBuilder.getEscapedIdentifier(each.getName()) + " = ?").collect(Collectors.joining(" AND ")));
    }
}

