/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.metadata.generator;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.ddl.AlterTableStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.ddl.CommentStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.ddl.CreateIndexStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.ddl.CreateTableStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.ConstraintAvailable;
import org.apache.shardingsphere.infra.binder.context.type.IndexAvailable;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.binder.engine.SQLBindEngine;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.util.IndexMetaDataUtils;
import org.apache.shardingsphere.infra.parser.SQLParserEngine;
import org.apache.shardingsphere.sql.parser.statement.core.segment.SQLSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableNameSegment;

public final class PipelineDDLDecorator {
    private static final String SET_SEARCH_PATH_PREFIX = "set search_path";
    private final ShardingSphereMetaData metaData;

    public Optional<String> decorate(DatabaseType databaseType, String targetDatabaseName, String schemaName, String targetTableName, SQLParserEngine parserEngine, String sql) {
        if (Strings.isNullOrEmpty((String)sql)) {
            return Optional.empty();
        }
        String result = this.decorateActualSQL(targetDatabaseName, targetTableName, parserEngine, sql.trim());
        if ("openGauss".equals(databaseType.getType())) {
            return this.decorateOpenGauss(targetDatabaseName, schemaName, result, parserEngine);
        }
        return Optional.of(result);
    }

    private String decorateActualSQL(String databaseName, String targetTableName, SQLParserEngine parserEngine, String sql) {
        SQLStatementContext sqlStatementContext = this.parseSQL(databaseName, parserEngine, sql);
        TreeMap<SQLSegment, String> replaceMap = new TreeMap<SQLSegment, String>(Comparator.comparing(SQLSegment::getStartIndex));
        if (sqlStatementContext instanceof CreateTableStatementContext) {
            this.appendFromIndexAndConstraint(replaceMap, targetTableName, sqlStatementContext);
            this.appendFromTable(replaceMap, targetTableName, (TableAvailable)sqlStatementContext);
        }
        if (sqlStatementContext instanceof CommentStatementContext) {
            this.appendFromTable(replaceMap, targetTableName, (TableAvailable)sqlStatementContext);
        }
        if (sqlStatementContext instanceof CreateIndexStatementContext) {
            this.appendFromTable(replaceMap, targetTableName, (TableAvailable)sqlStatementContext);
            this.appendFromIndexAndConstraint(replaceMap, targetTableName, sqlStatementContext);
        }
        if (sqlStatementContext instanceof AlterTableStatementContext) {
            this.appendFromIndexAndConstraint(replaceMap, targetTableName, sqlStatementContext);
            this.appendFromTable(replaceMap, targetTableName, (TableAvailable)sqlStatementContext);
        }
        return this.doDecorateActualTable(replaceMap, sql);
    }

    private SQLStatementContext parseSQL(String currentDatabaseName, SQLParserEngine parserEngine, String sql) {
        return new SQLBindEngine(this.metaData, currentDatabaseName, new HintValueContext()).bind(parserEngine.parse(sql, true), Collections.emptyList());
    }

    private void appendFromIndexAndConstraint(Map<SQLSegment, String> replaceMap, String targetTableName, SQLStatementContext sqlStatementContext) {
        if (!(sqlStatementContext instanceof TableAvailable) || ((TableAvailable)sqlStatementContext).getTablesContext().getSimpleTables().isEmpty()) {
            return;
        }
        TableNameSegment tableNameSegment = ((SimpleTableSegment)((TableAvailable)sqlStatementContext).getTablesContext().getSimpleTables().iterator().next()).getTableName();
        if (!tableNameSegment.getIdentifier().getValue().equals(targetTableName)) {
            if (sqlStatementContext instanceof IndexAvailable) {
                for (IndexSegment each : ((IndexAvailable)sqlStatementContext).getIndexes()) {
                    String logicIndexName = IndexMetaDataUtils.getLogicIndexName((String)each.getIndexName().getIdentifier().getValue(), (String)tableNameSegment.getIdentifier().getValue());
                    replaceMap.put((SQLSegment)each.getIndexName(), logicIndexName);
                }
            }
            if (sqlStatementContext instanceof ConstraintAvailable) {
                for (IndexSegment each : ((ConstraintAvailable)sqlStatementContext).getConstraints()) {
                    String logicConstraint = IndexMetaDataUtils.getLogicIndexName((String)each.getIdentifier().getValue(), (String)tableNameSegment.getIdentifier().getValue());
                    replaceMap.put((SQLSegment)each, logicConstraint);
                }
            }
        }
    }

    private void appendFromTable(Map<SQLSegment, String> replaceMap, String targetTableName, TableAvailable sqlStatementContext) {
        for (SimpleTableSegment each : sqlStatementContext.getTablesContext().getSimpleTables()) {
            if (targetTableName.equals(each.getTableName().getIdentifier().getValue())) continue;
            replaceMap.put((SQLSegment)each.getTableName(), targetTableName);
        }
    }

    private String doDecorateActualTable(Map<SQLSegment, String> replaceMap, String sql) {
        StringBuilder result = new StringBuilder();
        int lastStopIndex = 0;
        for (Map.Entry<SQLSegment, String> entry : replaceMap.entrySet()) {
            result.append(sql, lastStopIndex, entry.getKey().getStartIndex());
            result.append(entry.getValue());
            lastStopIndex = entry.getKey().getStopIndex() + 1;
        }
        if (lastStopIndex < sql.length()) {
            result.append(sql, lastStopIndex, sql.length());
        }
        return result.toString();
    }

    private Optional<String> decorateOpenGauss(String databaseName, String schemaName, String queryContext, SQLParserEngine parserEngine) {
        if (queryContext.toLowerCase().startsWith(SET_SEARCH_PATH_PREFIX)) {
            return Optional.empty();
        }
        return Optional.of(this.replaceTableNameWithPrefix(queryContext, schemaName, databaseName, parserEngine));
    }

    private String replaceTableNameWithPrefix(String sql, String schemaName, String databaseName, SQLParserEngine parserEngine) {
        SQLStatementContext sqlStatementContext = this.parseSQL(databaseName, parserEngine, sql);
        if (sqlStatementContext instanceof CreateTableStatementContext || sqlStatementContext instanceof CommentStatementContext || sqlStatementContext instanceof CreateIndexStatementContext || sqlStatementContext instanceof AlterTableStatementContext) {
            if (((TableAvailable)sqlStatementContext).getTablesContext().getSimpleTables().isEmpty()) {
                return sql;
            }
            Optional sqlSchemaName = ((TableAvailable)sqlStatementContext).getTablesContext().getSchemaName();
            if (sqlSchemaName.isPresent() && ((String)sqlSchemaName.get()).equals(schemaName)) {
                return sql;
            }
            TreeMap<SQLSegment, String> replaceMap = new TreeMap<SQLSegment, String>(Comparator.comparing(SQLSegment::getStartIndex));
            TableNameSegment tableNameSegment = ((SimpleTableSegment)((TableAvailable)sqlStatementContext).getTablesContext().getSimpleTables().iterator().next()).getTableName();
            replaceMap.put((SQLSegment)tableNameSegment, schemaName + "." + tableNameSegment.getIdentifier().getValue());
            return this.doDecorateActualTable(replaceMap, sql);
        }
        return sql;
    }

    @Generated
    public PipelineDDLDecorator(ShardingSphereMetaData metaData) {
        this.metaData = metaData;
    }
}

