/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.datanode;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.datanode.DataNodeUtils;
import org.apache.shardingsphere.infra.datanode.DataNode;

public final class JobDataNodeEntry {
    private final String logicTableName;
    private final List<DataNode> dataNodes;

    public static JobDataNodeEntry unmarshal(String text) {
        List segments = Splitter.on((String)":").splitToList((CharSequence)text);
        String logicTableName = (String)segments.get(0);
        List<DataNode> dataNodes = Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)segments.get(1)).stream().map(DataNodeUtils::parseWithSchema).collect(Collectors.toList());
        return new JobDataNodeEntry(logicTableName, dataNodes);
    }

    public String marshal() {
        return this.logicTableName + ':' + this.dataNodes.stream().map(DataNode::format).collect(Collectors.joining(","));
    }

    @Generated
    public JobDataNodeEntry(String logicTableName, List<DataNode> dataNodes) {
        this.logicTableName = logicTableName;
        this.dataNodes = dataNodes;
    }

    @Generated
    public String getLogicTableName() {
        return this.logicTableName;
    }

    @Generated
    public List<DataNode> getDataNodes() {
        return this.dataNodes;
    }
}

