/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.core.builder;

import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import org.apache.shardingsphere.agent.api.PluginConfiguration;
import org.apache.shardingsphere.agent.core.advisor.config.AdvisorConfiguration;
import org.apache.shardingsphere.agent.core.advisor.config.MethodAdvisorConfiguration;
import org.apache.shardingsphere.agent.core.builder.interceptor.AgentBuilderInterceptChainEngine;
import org.apache.shardingsphere.agent.core.builder.interceptor.impl.MethodAdvisorBuilderInterceptor;
import org.apache.shardingsphere.agent.core.builder.interceptor.impl.TargetAdviceObjectBuilderInterceptor;
import org.apache.shardingsphere.agent.core.plugin.PluginLifecycleServiceManager;
import org.apache.shardingsphere.agent.core.plugin.classloader.AgentPluginClassLoader;
import org.apache.shardingsphere.agent.core.plugin.classloader.ClassLoaderContext;
import org.apache.shardingsphere.shade.net.bytebuddy.agent.builder.AgentBuilder;
import org.apache.shardingsphere.shade.net.bytebuddy.description.type.TypeDescription;
import org.apache.shardingsphere.shade.net.bytebuddy.dynamic.DynamicType;
import org.apache.shardingsphere.shade.net.bytebuddy.pool.TypePool;
import org.apache.shardingsphere.shade.net.bytebuddy.utility.JavaModule;

public final class AgentTransformer
implements AgentBuilder.Transformer {
    private static final Logger LOGGER = Logger.getLogger(AgentTransformer.class.getName());
    private static final Map<AgentPluginClassLoader, TypePool> TYPE_POOL_MAP = new ConcurrentHashMap<AgentPluginClassLoader, TypePool>();
    private final Map<String, PluginConfiguration> pluginConfigs;
    private final Collection<JarFile> pluginJars;
    private final Map<String, AdvisorConfiguration> advisorConfigs;
    private final boolean isEnhancedForProxy;

    @Override
    public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, ProtectionDomain protectionDomain) {
        if (!this.advisorConfigs.containsKey(typeDescription.getTypeName())) {
            return builder;
        }
        ClassLoaderContext classLoaderContext = new ClassLoaderContext(classLoader, this.pluginJars);
        PluginLifecycleServiceManager.init(this.pluginConfigs, this.pluginJars, classLoaderContext.getPluginClassLoader(), this.isEnhancedForProxy);
        return AgentBuilderInterceptChainEngine.intercept(builder, new TargetAdviceObjectBuilderInterceptor(), new MethodAdvisorBuilderInterceptor(typeDescription, classLoaderContext, this.filterInvalidAdviceClass(this.advisorConfigs.get(typeDescription.getTypeName()), classLoaderContext)));
    }

    private AdvisorConfiguration filterInvalidAdviceClass(AdvisorConfiguration advisorConfig, ClassLoaderContext classLoaderContext) {
        AdvisorConfiguration result = new AdvisorConfiguration(advisorConfig.getTargetClassName());
        for (MethodAdvisorConfiguration each : advisorConfig.getAdvisors()) {
            if (this.isExist(each.getAdviceClassName(), classLoaderContext.getPluginClassLoader())) {
                result.getAdvisors().add(each);
                continue;
            }
            LOGGER.log(Level.SEVERE, "The advice class `{0}` does not exist", new String[]{each.getAdviceClassName()});
        }
        return result;
    }

    private boolean isExist(String adviceClassName, AgentPluginClassLoader pluginClassLoader) {
        TypePool typePool = TYPE_POOL_MAP.get(pluginClassLoader);
        return null == typePool ? TYPE_POOL_MAP.computeIfAbsent(pluginClassLoader, TypePool.Default::of).describe(adviceClassName).isResolved() : typePool.describe(adviceClassName).isResolved();
    }

    @Generated
    public AgentTransformer(Map<String, PluginConfiguration> pluginConfigs, Collection<JarFile> pluginJars, Map<String, AdvisorConfiguration> advisorConfigs, boolean isEnhancedForProxy) {
        this.pluginConfigs = pluginConfigs;
        this.pluginJars = pluginJars;
        this.advisorConfigs = advisorConfigs;
        this.isEnhancedForProxy = isEnhancedForProxy;
    }
}

