/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.converter;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.handler.engine.query.ral.convert.AlgorithmDistSQLConverter;
import org.apache.shardingsphere.distsql.handler.engine.query.ral.convert.RuleConfigurationToDistSQLConverter;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableReferenceRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.audit.ShardingAuditStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.keygen.KeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ComplexShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.StandardShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.distsql.handler.converter.ShardingConvertDistSQLConstants;

public final class ShardingRuleConfigurationToDistSQLConverter
implements RuleConfigurationToDistSQLConverter<ShardingRuleConfiguration> {
    public String convert(ShardingRuleConfiguration ruleConfig) {
        if (ruleConfig.getTables().isEmpty() && ruleConfig.getAutoTables().isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append(this.convertShardingTableRules(ruleConfig));
        if (!ruleConfig.getBindingTableGroups().isEmpty()) {
            result.append(System.lineSeparator()).append(System.lineSeparator());
            result.append(this.convertShardingBindingTableRules(ruleConfig));
        }
        if (null != ruleConfig.getDefaultDatabaseShardingStrategy() || null != ruleConfig.getDefaultTableShardingStrategy()) {
            result.append(System.lineSeparator()).append(System.lineSeparator());
            result.append(this.convertDefaultShardingStrategy(ruleConfig));
        }
        return result.toString();
    }

    private String convertShardingTableRules(ShardingRuleConfiguration ruleConfig) {
        StringBuilder result = new StringBuilder();
        result.append("CREATE SHARDING TABLE RULE").append(this.convertTableRules(ruleConfig));
        if (!ruleConfig.getTables().isEmpty() && !ruleConfig.getAutoTables().isEmpty()) {
            result.append(",");
        }
        result.append(this.convertAutoTableRules(ruleConfig)).append(";");
        return result.toString();
    }

    private String convertTableRules(ShardingRuleConfiguration ruleConfig) {
        if (ruleConfig.getTables().isEmpty()) {
            return "";
        }
        return ruleConfig.getTables().stream().map(each -> String.format(ShardingConvertDistSQLConstants.SHARDING_TABLE_RULE, each.getLogicTable(), each.getActualDataNodes(), this.convertTableStrategy((ShardingTableRuleConfiguration)each, ruleConfig))).collect(Collectors.joining(","));
    }

    private String convertTableStrategy(ShardingTableRuleConfiguration tableRuleConfig, ShardingRuleConfiguration ruleConfig) {
        return this.convertShardingStrategy(tableRuleConfig.getDatabaseShardingStrategy(), "DATABASE_STRATEGY", ruleConfig.getShardingAlgorithms()) + this.convertShardingStrategy(tableRuleConfig.getTableShardingStrategy(), "TABLE_STRATEGY", ruleConfig.getShardingAlgorithms()) + this.convertKeyGenerateStrategy(ruleConfig.getKeyGenerators(), tableRuleConfig.getKeyGenerateStrategy()) + this.convertAuditStrategy(ruleConfig.getAuditors(), null == tableRuleConfig.getAuditStrategy() ? ruleConfig.getDefaultAuditStrategy() : tableRuleConfig.getAuditStrategy());
    }

    private String convertAutoTableRules(ShardingRuleConfiguration ruleConfig) {
        if (ruleConfig.getAutoTables().isEmpty()) {
            return "";
        }
        return ruleConfig.getAutoTables().stream().map(each -> String.format(ShardingConvertDistSQLConstants.SHARDING_AUTO_TABLE_RULE, each.getLogicTable(), each.getActualDataSources(), this.convertAutoTableStrategy((ShardingAutoTableRuleConfiguration)each, ruleConfig))).collect(Collectors.joining(","));
    }

    private String convertAutoTableStrategy(ShardingAutoTableRuleConfiguration autoTableRuleConfig, ShardingRuleConfiguration ruleConfig) {
        StringBuilder result = new StringBuilder();
        StandardShardingStrategyConfiguration strategyConfig = (StandardShardingStrategyConfiguration)autoTableRuleConfig.getShardingStrategy();
        String shardingColumn = Strings.isNullOrEmpty((String)strategyConfig.getShardingColumn()) ? ruleConfig.getDefaultShardingColumn() : strategyConfig.getShardingColumn();
        result.append(String.format(ShardingConvertDistSQLConstants.AUTO_TABLE_STRATEGY, shardingColumn, AlgorithmDistSQLConverter.getAlgorithmType((AlgorithmConfiguration)((AlgorithmConfiguration)ruleConfig.getShardingAlgorithms().get(strategyConfig.getShardingAlgorithmName())))));
        result.append(this.convertKeyGenerateStrategy(ruleConfig.getKeyGenerators(), autoTableRuleConfig.getKeyGenerateStrategy()));
        result.append(this.convertAuditStrategy(ruleConfig.getAuditors(), null == autoTableRuleConfig.getAuditStrategy() ? ruleConfig.getDefaultAuditStrategy() : autoTableRuleConfig.getAuditStrategy()));
        return result.toString();
    }

    private String convertKeyGenerateStrategy(Map<String, AlgorithmConfiguration> keyGenerators, KeyGenerateStrategyConfiguration keyGenerateStrategyConfig) {
        if (null == keyGenerateStrategyConfig) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append(",").append(System.lineSeparator());
        String algorithmDefinition = AlgorithmDistSQLConverter.getAlgorithmType((AlgorithmConfiguration)keyGenerators.get(keyGenerateStrategyConfig.getKeyGeneratorName()));
        result.append(String.format("KEY_GENERATE_STRATEGY(COLUMN=%s, %s)", keyGenerateStrategyConfig.getColumn(), algorithmDefinition));
        return result.toString();
    }

    private String convertShardingBindingTableRules(ShardingRuleConfiguration ruleConfig) {
        return "CREATE SHARDING TABLE REFERENCE RULE" + this.convertShardingBindingTableRules(ruleConfig.getBindingTableGroups()) + ";";
    }

    private String convertShardingBindingTableRules(Collection<ShardingTableReferenceRuleConfiguration> bindingTableGroups) {
        return bindingTableGroups.stream().map(each -> String.format(" %s (%s)", each.getName(), each.getReference())).collect(Collectors.joining(","));
    }

    private String convertDefaultShardingStrategy(ShardingRuleConfiguration ruleConfig) {
        StringBuilder result = new StringBuilder();
        if (null != ruleConfig.getDefaultDatabaseShardingStrategy()) {
            result.append(this.convertShardingStrategy(ruleConfig.getDefaultDatabaseShardingStrategy(), "CREATE DEFAULT SHARDING DATABASE STRATEGY", ruleConfig.getShardingAlgorithms()));
            result.append(";");
        }
        if (null != ruleConfig.getDefaultTableShardingStrategy()) {
            if (null != ruleConfig.getDefaultDatabaseShardingStrategy()) {
                result.append(System.lineSeparator()).append(System.lineSeparator());
            }
            result.append(this.convertShardingStrategy(ruleConfig.getDefaultTableShardingStrategy(), "CREATE DEFAULT SHARDING TABLE STRATEGY", ruleConfig.getShardingAlgorithms()));
            result.append(";");
        }
        return result.toString();
    }

    private String convertShardingStrategy(ShardingStrategyConfiguration strategyConfig, String strategyType, Map<String, AlgorithmConfiguration> shardingAlgorithms) {
        if (null == strategyConfig) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        if (Objects.equals(strategyType, "DATABASE_STRATEGY") || Objects.equals(strategyType, "TABLE_STRATEGY")) {
            result.append(",").append(System.lineSeparator());
        }
        String type = strategyConfig.getType().toLowerCase();
        String algorithmDefinition = AlgorithmDistSQLConverter.getAlgorithmType((AlgorithmConfiguration)shardingAlgorithms.get(strategyConfig.getShardingAlgorithmName()));
        switch (type) {
            case "standard": {
                StandardShardingStrategyConfiguration standardConfig = (StandardShardingStrategyConfiguration)strategyConfig;
                result.append(String.format("%s(TYPE='%s', SHARDING_COLUMN=%s, SHARDING_ALGORITHM(%s))", strategyType, type, standardConfig.getShardingColumn(), algorithmDefinition));
                break;
            }
            case "complex": {
                ComplexShardingStrategyConfiguration complexConfig = (ComplexShardingStrategyConfiguration)strategyConfig;
                result.append(String.format("%s(TYPE='%s', SHARDING_COLUMNS=%s, SHARDING_ALGORITHM(%s))", strategyType, type, complexConfig.getShardingColumns(), algorithmDefinition));
                break;
            }
            case "hint": {
                result.append(String.format("%s(TYPE='%s', SHARDING_ALGORITHM(%s))", strategyType, type, algorithmDefinition));
                break;
            }
            case "": {
                result.append(String.format("%s(TYPE='%s')", strategyType, "none"));
                break;
            }
        }
        return result.toString();
    }

    private String convertAuditStrategy(Map<String, AlgorithmConfiguration> auditors, ShardingAuditStrategyConfiguration auditStrategy) {
        return null == auditStrategy ? "" : "," + System.lineSeparator() + String.format("AUDIT_STRATEGY(%s, ALLOW_HINT_DISABLE=%s)", this.convertAlgorithmTypes(auditStrategy.getAuditorNames(), auditors), auditStrategy.isAllowHintDisable());
    }

    private String convertAlgorithmTypes(Collection<String> auditorNames, Map<String, AlgorithmConfiguration> auditors) {
        return auditorNames.stream().map(each -> AlgorithmDistSQLConverter.getAlgorithmType((AlgorithmConfiguration)((AlgorithmConfiguration)auditors.get(each)))).collect(Collectors.joining(","));
    }

    public Class<ShardingRuleConfiguration> getType() {
        return ShardingRuleConfiguration.class;
    }
}

