/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.plugin.metrics.core.exporter.impl.proxy;

import java.util.Collections;
import java.util.Optional;
import org.apache.shardingsphere.agent.plugin.metrics.core.collector.MetricsCollectorRegistry;
import org.apache.shardingsphere.agent.plugin.metrics.core.collector.type.GaugeMetricFamilyMetricsCollector;
import org.apache.shardingsphere.agent.plugin.metrics.core.config.MetricCollectorType;
import org.apache.shardingsphere.agent.plugin.metrics.core.config.MetricConfiguration;
import org.apache.shardingsphere.agent.plugin.metrics.core.exporter.MetricsExporter;
import org.apache.shardingsphere.infra.state.instance.InstanceStateContext;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;

public final class ProxyStateExporter
implements MetricsExporter {
    private final MetricConfiguration config = new MetricConfiguration("proxy_state", MetricCollectorType.GAUGE_METRIC_FAMILY, "State of ShardingSphere-Proxy. 0 is OK; 1 is CIRCUIT BREAK; 2 is LOCK", Collections.emptyList(), Collections.emptyMap());

    @Override
    public Optional<GaugeMetricFamilyMetricsCollector> export(String pluginType) {
        if (null == ProxyContext.getInstance().getContextManager()) {
            return Optional.empty();
        }
        Optional stateContext = ProxyContext.getInstance().getInstanceStateContext();
        if (!stateContext.isPresent()) {
            return Optional.empty();
        }
        GaugeMetricFamilyMetricsCollector result = (GaugeMetricFamilyMetricsCollector)MetricsCollectorRegistry.get(this.config, pluginType);
        result.cleanMetrics();
        result.addMetric(Collections.emptyList(), ((InstanceStateContext)stateContext.get()).getCurrentState().ordinal());
        return Optional.of(result);
    }
}

