/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.rule;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.attribute.RuleAttribute;
import org.apache.shardingsphere.infra.rule.attribute.datanode.DataNodeRuleAttribute;
import org.apache.shardingsphere.infra.rule.attribute.datasource.DataSourceMapperRuleAttribute;

public final class RuleMetaData {
    private final Collection<ShardingSphereRule> rules;

    public RuleMetaData(Collection<ShardingSphereRule> rules) {
        this.rules = new CopyOnWriteArrayList<ShardingSphereRule>(rules);
    }

    public Collection<RuleConfiguration> getConfigurations() {
        return this.rules.stream().map(ShardingSphereRule::getConfiguration).collect(Collectors.toList());
    }

    public <T extends ShardingSphereRule> Collection<T> findRules(Class<T> clazz) {
        LinkedList<ShardingSphereRule> result = new LinkedList<ShardingSphereRule>();
        for (ShardingSphereRule each : this.rules) {
            if (!clazz.isAssignableFrom(each.getClass())) continue;
            result.add((ShardingSphereRule)clazz.cast(each));
        }
        return result;
    }

    public <T extends ShardingSphereRule> Optional<T> findSingleRule(Class<T> clazz) {
        Collection<T> foundRules = this.findRules(clazz);
        return foundRules.isEmpty() ? Optional.empty() : Optional.of((ShardingSphereRule)foundRules.iterator().next());
    }

    public <T extends ShardingSphereRule> T getSingleRule(Class<T> clazz) {
        Collection<T> foundRules = this.findRules(clazz);
        Preconditions.checkState((1 == foundRules.size() ? 1 : 0) != 0, (String)"Rule `%s` should have and only have one instance.", (Object)clazz.getSimpleName());
        return (T)((ShardingSphereRule)foundRules.iterator().next());
    }

    public Map<String, Collection<Class<? extends ShardingSphereRule>>> getInUsedStorageUnitNameAndRulesMap() {
        LinkedHashMap<String, Collection<Class<? extends ShardingSphereRule>>> result = new LinkedHashMap<String, Collection<Class<? extends ShardingSphereRule>>>();
        for (ShardingSphereRule each : this.rules) {
            Collection<String> inUsedStorageUnitNames = this.getInUsedStorageUnitNames(each);
            if (inUsedStorageUnitNames.isEmpty()) continue;
            this.mergeInUsedStorageUnitNameAndRules(result, this.getInUsedStorageUnitNameAndRulesMap(each, inUsedStorageUnitNames));
        }
        return result;
    }

    private Map<String, Collection<Class<? extends ShardingSphereRule>>> getInUsedStorageUnitNameAndRulesMap(ShardingSphereRule rule, Collection<String> inUsedStorageUnitNames) {
        LinkedHashMap<String, Collection<Class<? extends ShardingSphereRule>>> result = new LinkedHashMap<String, Collection<Class<? extends ShardingSphereRule>>>();
        for (String each : inUsedStorageUnitNames) {
            if (!result.containsKey(each)) {
                result.put(each, new LinkedHashSet());
            }
            ((Collection)result.get(each)).add(rule.getClass());
        }
        return result;
    }

    private Collection<String> getInUsedStorageUnitNames(ShardingSphereRule rule) {
        Optional<DataSourceMapperRuleAttribute> dataSourceMapperRuleAttribute = rule.getAttributes().findAttribute(DataSourceMapperRuleAttribute.class);
        if (dataSourceMapperRuleAttribute.isPresent()) {
            return this.getInUsedStorageUnitNames(dataSourceMapperRuleAttribute.get());
        }
        Optional<DataNodeRuleAttribute> dataNodeRuleAttribute = rule.getAttributes().findAttribute(DataNodeRuleAttribute.class);
        if (dataNodeRuleAttribute.isPresent()) {
            return this.getInUsedStorageUnitNames(dataNodeRuleAttribute.get());
        }
        return Collections.emptyList();
    }

    private Collection<String> getInUsedStorageUnitNames(DataSourceMapperRuleAttribute ruleAttribute) {
        return ruleAttribute.getDataSourceMapper().values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private Collection<String> getInUsedStorageUnitNames(DataNodeRuleAttribute ruleAttribute) {
        return ruleAttribute.getAllDataNodes().values().stream().flatMap(each -> each.stream().map(DataNode::getDataSourceName).collect(Collectors.toSet()).stream()).collect(Collectors.toSet());
    }

    private void mergeInUsedStorageUnitNameAndRules(Map<String, Collection<Class<? extends ShardingSphereRule>>> storageUnitNameAndRules, Map<String, Collection<Class<? extends ShardingSphereRule>>> toBeMergedStorageUnitNameAndRules) {
        for (Map.Entry<String, Collection<Class<? extends ShardingSphereRule>>> entry : toBeMergedStorageUnitNameAndRules.entrySet()) {
            if (storageUnitNameAndRules.containsKey(entry.getKey())) {
                for (Class<? extends ShardingSphereRule> each : entry.getValue()) {
                    if (storageUnitNameAndRules.get(entry.getKey()).contains(each)) continue;
                    storageUnitNameAndRules.get(entry.getKey()).add(each);
                }
                continue;
            }
            storageUnitNameAndRules.put(entry.getKey(), entry.getValue());
        }
    }

    public <T extends RuleAttribute> Collection<T> getAttributes(Class<T> attributeClass) {
        LinkedList result = new LinkedList();
        for (ShardingSphereRule each : this.rules) {
            each.getAttributes().findAttribute(attributeClass).ifPresent(result::add);
        }
        return result;
    }

    public <T extends RuleAttribute> Optional<T> findAttribute(Class<T> attributeClass) {
        for (ShardingSphereRule each : this.rules) {
            if (!each.getAttributes().findAttribute(attributeClass).isPresent()) continue;
            return each.getAttributes().findAttribute(attributeClass);
        }
        return Optional.empty();
    }

    @Generated
    public Collection<ShardingSphereRule> getRules() {
        return this.rules;
    }
}

